/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.kiribachi;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KiribachiFrenzyAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kiribachi_frenzy", (Pair[])new Pair[]{ImmutablePair.of((Object)"By spinning, the user slashes and weakens nearby opponents", null)});
    private static final int HOLD_TIME = 80;
    private static final float COOLDOWN = 300.0f;
    private static final float DAMAGE = 2.0f;
    private static final float RANGE = 5.5f;
    private final Interval damageInterval = new Interval(20);
    public static final AbilityCore<KiribachiFrenzyAbility> INSTANCE = new AbilityCore.Builder("Kiribachi Frenzy", AbilityCategory.EQUIPMENT, KiribachiFrenzyAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)20.0f, (float)80.0f), ContinuousComponent.getTooltip((float)80.0f), CooldownComponent.getTooltip((float)300.0f), RangeComponent.getTooltip((float)5.5f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).setUnlockCheck(KiribachiFrenzyAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(100, this::startContinuousEvent).addTickEvent(100, this::tickContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private static final AbilityAttributeModifier STEP_HEIGHT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("3af6870a-22dd-4e20-9205-d0a11801e7b5"), INSTANCE, "Kiribachi Step Height Modifier", 1.5, AttributeModifier.Operation.ADDITION);

    public KiribachiFrenzyAbility(AbilityCore<KiribachiFrenzyAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.statsComponent, this.continuousComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent});
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT_MODIFIER);
        this.addUseEvent(this::onUseEvent);
        super.addEquipEvent(this::equipEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_184614_ca().func_77973_b().equals(ModWeapons.KIRIBACHI.get())) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a Kiribachi to use this move!"), entity.func_110124_au());
            return;
        }
        this.continuousComponent.triggerContinuity(entity, 80.0f);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.applyModifiers(entity);
        ItemStack stack = entity.func_184614_ca();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        this.damageInterval.restartIntervalToZero();
        this.animationComponent.start(entity, ModAnimations.BODY_ROTATION_WIDE_ARMS);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.SPIN.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 4.0f);
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        Vector3d look = entity.func_70040_Z().func_72432_b();
        Vector3d move = look.func_186678_a(0.9);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)move.field_72450_a, (double)-5.0, (double)move.field_72449_c);
        if (!entity.func_184614_ca().func_77973_b().equals(ModWeapons.KIRIBACHI.get())) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a Kiribachi to use this move!"), entity.func_110124_au());
            this.continuousComponent.stopContinuity(entity);
        }
        if (this.damageInterval.canTick()) {
            List list = this.rangeComponent.getTargetsInArea(entity, 5.5f);
            AbilityDamageSource source = (AbilityDamageSource)((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setSlash();
            for (LivingEntity target : list) {
                this.dealDamageComponent.hurtTarget(entity, target, 20.0f, (DamageSource)source);
                if (entity.field_70170_p.field_72995_K) continue;
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)target.func_70047_e()), (double)target.func_226281_cx_());
            }
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 0, false, false));
        if (!entity.field_70170_p.field_72995_K && this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.SPIN.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 4.0f);
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.removeModifiers(entity);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        return KiribachiFrenzyAbility.hasItem(entity);
    }

    private static boolean hasItem(LivingEntity entity) {
        for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
            if (!itemStack.func_77973_b().equals(ModWeapons.KIRIBACHI.get())) continue;
            return true;
        }
        return false;
    }
}

