/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.kiribachi;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class KiribachiCleaveAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kiribachi_cleave", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges and slams down their weapon, inflicting bleeding.", null)});
    private static final int CHARGE_TIME = 10;
    private static final int COOLDOWN = 100;
    private static final float DAMAGE = 30.0f;
    private static final int RANGE = 5;
    public static final AbilityCore<KiribachiCleaveAbility> INSTANCE = new AbilityCore.Builder("Kiribachi Cleave", AbilityCategory.EQUIPMENT, KiribachiCleaveAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)30.0f), ChargeComponent.getTooltip((float)10.0f), CooldownComponent.getTooltip((float)160.0f), RangeComponent.getTooltip((float)5.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(KiribachiCleaveAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addEndEvent(this::stopChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final DealDamageComponent damageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);

    public KiribachiCleaveAbility(AbilityCore<KiribachiCleaveAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.animationComponent, this.damageComponent, this.rangeComponent});
        this.addUseEvent(this::onUseEvent);
        super.addEquipEvent(this::equipEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_184614_ca().func_77973_b().equals(ModWeapons.KIRIBACHI.get())) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a Kiribachi to use this move!"), entity.func_110124_au());
            return;
        }
        this.chargeComponent.startCharging(entity, 10.0f);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            this.animationComponent.start(entity, CartAnimations.STRIKING_SWING_RIGHT);
        } else if (entity.func_184591_cq() == HandSide.LEFT) {
            this.animationComponent.start(entity, CartAnimations.STRIKING_SWING_LEFT);
        }
    }

    private void stopChargeEvent(LivingEntity entity, IAbility ability) {
        List targets = this.rangeComponent.getTargetsInLine(entity, 5.0f, 2.0f);
        for (LivingEntity target : targets) {
            if (!this.damageComponent.hurtTarget(entity, target, 30.0f)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 40, 0));
            Vector3d dirVec = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_216372_d(2.5, 1.0, 2.5);
            AbilityHelper.setDeltaMovement((Entity)target, (double)dirVec.field_72450_a, (double)0.2, (double)dirVec.field_72449_c);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        return KiribachiCleaveAbility.hasItem(entity);
    }

    private static boolean hasItem(LivingEntity entity) {
        for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
            if (!itemStack.func_77973_b().equals(ModWeapons.KIRIBACHI.get())) continue;
            return true;
        }
        return false;
    }
}

