/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.kiraextra;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.api.abilities.CartPunchAbility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NewCabochonKnuckleAbility
extends CartPunchAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"cabochon_knuckle", (Pair[])new Pair[]{ImmutablePair.of((Object)"Covers the user's punch in a diamond coating, dealing damage and slight knockback.", null)});
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.DIAMOND_BODY).setOverlayPart(AbilityOverlay.OverlayPart.LIMB).build();
    private static final float COOLDOWN = 160.0f;
    public static final AbilityCore<NewCabochonKnuckleAbility> INSTANCE = new AbilityCore.Builder("Cabochon Knuckle", AbilityCategory.DEVIL_FRUITS, NewCabochonKnuckleAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)15.0f), CooldownComponent.getTooltip((float)160.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).build();
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);

    public NewCabochonKnuckleAbility(AbilityCore<NewCabochonKnuckleAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.skinOverlayComponent});
        this.continuousComponent.addStartEvent(100, this::onContinuityStart);
        this.continuousComponent.addEndEvent(100, this::onContinuityEnd);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)3.0, (double)3.0);
        AbilityHelper.setDeltaMovement((Entity)target, (Vector3d)target.func_213322_ci().func_72441_c(speed.field_72450_a, 0.5, speed.field_72449_c));
        target.func_230245_c_(false);
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    @Override
    public float getPunchDamage() {
        return 15.0f;
    }

    @Override
    public float getPunchCooldown() {
        return 160.0f;
    }

    @Override
    public int getUseLimit() {
        return 1;
    }
}

