/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.kiraextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.kiraextra.NewDiamondBodyAbility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class NewBrilliantPunkAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"brilliant_punk", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user rams into the target with their diamond body.", null)});
    private static final int HOLD_TIME = 10;
    private static final int COOLDOWN = 200;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 25.0f;
    public static final AbilityCore<NewBrilliantPunkAbility> INSTANCE = new AbilityCore.Builder("Brilliant Punk", AbilityCategory.DEVIL_FRUITS, NewBrilliantPunkAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f), RangeComponent.getTooltip((float)1.6f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip((float)25.0f)}).setSourceType(new SourceType[]{SourceType.PHYSICAL}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);

    public NewBrilliantPunkAbility(AbilityCore<NewBrilliantPunkAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(this::requiresDiamondBody);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 10.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.animationComponent.start(entity, ModAnimations.TACKLE);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(2.3, 0.0, 2.3);
            entity.func_213315_a(MoverType.SELF, speed);
            List targets = this.rangeComponent.getTargetsInArea(entity, 1.6f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                this.dealDamageComponent.hurtTarget(entity, target, 25.0f);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0));
            }
            for (LivingEntity target : this.hitTrackerComponent.getHits()) {
                target.func_70634_a(entity.func_226277_ct_() + look.field_72450_a, entity.func_226278_cu_(), entity.func_226281_cx_() + look.field_72449_c);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private AbilityUseResult requiresDiamondBody(LivingEntity entity, IAbility ability) {
        boolean diamondBodyActive;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        NewDiamondBodyAbility diamondBody = (NewDiamondBodyAbility)abilityProps.getEquippedAbility(NewDiamondBodyAbility.INSTANCE);
        boolean bl = diamondBodyActive = diamondBody != null && diamondBody.isContinuous();
        if (!diamondBodyActive) {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{this.getDisplayName().getString(), NewDiamondBodyAbility.INSTANCE.getUnlocalizedName()});
            return AbilityUseResult.fail((ITextComponent)text);
        }
        return AbilityUseResult.success();
    }
}

