/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.jitte;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class JitteJabAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"jitte_jab", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user thrusts their Jitte into an opponent, stunning them and disabling devil fruit abilities briefly.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int HOLD_TIME = 6;
    private static final int COOLDOWN = 360;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 30.0f;
    public static final AbilityCore<JitteJabAbility> INSTANCE = new AbilityCore.Builder("Jitte Jab", AbilityCategory.EQUIPMENT, JitteJabAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)360.0f), RangeComponent.getTooltip((float)1.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceType(new SourceType[]{SourceType.BLUNT}).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(JitteJabAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);

    public JitteJabAbility(AbilityCore<JitteJabAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
        super.addEquipEvent(this::equipEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_184614_ca().func_77973_b().equals(ModWeapons.JITTE.get())) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a Jitte to use this move!"), entity.func_110124_au());
            return;
        }
        this.continuousComponent.triggerContinuity(entity, 6.0f);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.cooldownComponent.startCooldown(entity, 360.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.animationComponent.start(entity, ModAnimations.POINT_WEAPON);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(1.6, 0.0, 1.6);
            entity.func_213315_a(MoverType.SELF, speed);
            List targets = this.rangeComponent.getTargetsInArea(entity, 1.0f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 20, 0, false, false));
                this.dealDamageComponent.hurtTarget(entity, target, 30.0f);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0, false, false));
                if (!(target instanceof PlayerEntity)) continue;
                AbilityHelper.disableAbilities((LivingEntity)target, (int)30, abl -> abl.getCore().getCategory() == AbilityCategory.DEVIL_FRUITS);
            }
            for (LivingEntity target : this.hitTrackerComponent.getHits()) {
                target.func_70634_a(entity.func_226277_ct_() + look.field_72450_a, entity.func_226278_cu_(), entity.func_226281_cx_() + look.field_72449_c);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 360.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        return JitteJabAbility.hasItem(entity);
    }

    private static boolean hasItem(LivingEntity entity) {
        for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
            if (!itemStack.func_77973_b().equals(ModWeapons.JITTE.get())) continue;
            return true;
        }
        return false;
    }
}

