/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.jikiextra;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.jikiextra.ReworkedPunkGibsonAbility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.PunkGibsonProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedRepelAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"repel", (Pair[])new Pair[]{ImmutablePair.of((Object)"Repels all metallic objects or projectiles near the user.", null), ImmutablePair.of((Object)"When %s is active this ability will instead shoot the metalic arm forward like a projectile.", (Object)new Object[]{ReworkedPunkGibsonAbility.INSTANCE}), ImmutablePair.of((Object)"Repeling enemies affected by %s into other enemies will deal damage and knock them back.", (Object)new Object[]{ModEffects.PUNK_CROSS})});
    private static final int COOLDOWN = 100;
    private static final int HOLD_TIME = 100;
    private static final int RANGE = 20;
    private static final int PUNK_CROSS_RANGE = 3;
    private static final int PUNK_CROSS_DAMAGE = 20;
    public static final AbilityCore<ReworkedRepelAbility> INSTANCE = new AbilityCore.Builder("Repel", AbilityCategory.DEVIL_FRUITS, ReworkedRepelAbility::new).addDescriptionLine(new ITextComponent[]{DESCRIPTION[0]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f), ContinuousComponent.getTooltip((float)100.0f), RangeComponent.getTooltip((float)20.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).addDescriptionLine(new ITextComponent[]{DESCRIPTION[1]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).addDescriptionLine(new ITextComponent[]{DESCRIPTION[2]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)20.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private ReworkedPunkGibsonAbility punkGibson;
    private HashSet<LivingEntity> punkCrossTargets = new HashSet();

    public ReworkedRepelAbility(AbilityCore<ReworkedRepelAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.projectileComponent, this.dealDamageComponent, this.rangeComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        boolean isGibsonActive;
        this.punkGibson = (ReworkedPunkGibsonAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedPunkGibsonAbility.INSTANCE);
        boolean bl = isGibsonActive = this.punkGibson != null && this.punkGibson.isContinuous();
        if (isGibsonActive) {
            this.projectileComponent.shoot(entity, 4.0f, 0.5f);
            this.punkGibson.stopItemDrops();
            this.punkGibson.getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.stopContinuity(entity));
        } else {
            this.continuousComponent.triggerContinuity(entity, 100.0f);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        targets = WyHelper.getNearbyEntities((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)20.0, (Predicate)null, (Class[])new Class[]{Entity.class});
        for (Entity target : targets) {
            flag = false;
            if (target.func_200600_R().func_220341_a((ITag)ModTags.Entities.MAGNETIC)) {
                flag = true;
            }
            if (target instanceof LivingEntity) {
                if (this.getIronArmorCoverPercentage((LivingEntity)target) >= 0.5f) {
                    flag = true;
                } else if (EntityStatsCapability.get((LivingEntity)((LivingEntity)target)).isCyborg()) {
                    flag = true;
                } else if (((LivingEntity)target).func_70644_a((Effect)ModEffects.PUNK_CROSS.get())) {
                    flag = true;
                    ((EffectInstanceMixin)((LivingEntity)target).func_70660_b((Effect)ModEffects.PUNK_CROSS.get())).setAmplifier(0);
                    this.punkCrossTargets.add((LivingEntity)target);
                }
            }
            if (flag) {
                dist = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_186678_a(2.0);
                AbilityHelper.setDeltaMovement((Entity)target, (double)dist.field_72450_a, (double)dist.field_72448_b, (double)dist.field_72449_c);
            }
            if (!(target instanceof ItemEntity) || (item = (ItemEntity)target).func_92059_d().func_190926_b() || !item.func_92059_d().func_77973_b().func_206844_a((ITag)ModTags.Items.MAGNETIC)) continue;
            vec = item.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72441_c(0.0, -1.0, 0.0);
            speedReduction = 8.0;
            speed = 2.0;
            xSpeed = Math.min(speed, -vec.field_72450_a / speedReduction);
            zSpeed = Math.min(speed, -vec.field_72449_c / speedReduction);
            AbilityHelper.setDeltaMovement((Entity)item, (double)(-xSpeed), (double)0.1, (double)(-zSpeed));
        }
        var4 = this.punkCrossTargets.iterator();
        block1: while (true) {
            if (!var4.hasNext()) {
                return;
            }
            target = (LivingEntity)var4.next();
            if (!target.func_70089_S() || target.func_233570_aj_()) continue;
            nearby = this.rangeComponent.getTargetsInArea(entity, 3.0f);
            nearby.remove(target);
            var19 = nearby.iterator();
            while (true) {
                if (var19.hasNext()) ** break;
                continue block1;
                target2 = (LivingEntity)var19.next();
                if (!this.dealDamageComponent.hurtTarget(entity, target2, 20.0f)) continue;
                speed = WyHelper.propulsion((LivingEntity)entity, (double)2.0, (double)2.0);
                AbilityHelper.setDeltaMovement((Entity)target2, (double)speed.field_72450_a, (double)0.5, (double)speed.field_72449_c);
            }
            break;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    private PunkGibsonProjectile createProjectile(LivingEntity entity) {
        if (this.punkGibson != null) {
            PunkGibsonProjectile proj = new PunkGibsonProjectile(entity.field_70170_p, entity, this.punkGibson.getMagneticItems());
            return proj;
        }
        PunkGibsonProjectile proj = new PunkGibsonProjectile(entity.field_70170_p, entity, new ArrayList());
        return proj;
    }

    public float getIronArmorCoverPercentage(LivingEntity target) {
        Iterable iterable = target.func_184193_aE();
        int i = 0;
        int j = 0;
        for (ItemStack itemstack : iterable) {
            if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_206844_a((ITag)ModTags.Items.MAGNETIC)) {
                ++j;
            }
            ++i;
        }
        return i > 0 ? (float)j / (float)i : 0.0f;
    }
}

