/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.jikiextra;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.PunkPistolProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class ReworkedPunkPistolsAbility
extends RepeaterAbility2 {
    private static final int VALUE_PER_SPEAR = 5;
    private static final int SPEARS = 6;
    private static final int INTERVAL = 4;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"punk_pistols", (Pair[])new Pair[]{ImmutablePair.of((Object)"Uses %s magnetic objects from the user's inventory to form %s spears and shoots them at enemies.", (Object)new Object[]{AbilityHelper.mentionText((Object)30), AbilityHelper.mentionText((Object)6)})});
    private static final int COOLDOWN = 240;
    public static final AbilityCore<ReworkedPunkPistolsAbility> INSTANCE = new AbilityCore.Builder("Punk Pistols", AbilityCategory.DEVIL_FRUITS, ReworkedPunkPistolsAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.METAL).build();
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public ReworkedPunkPistolsAbility(AbilityCore<ReworkedPunkPistolsAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.animationComponent});
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
        this.repeaterComponent.addTriggerEvent(this::triggerRepeaterEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        List inventory = ItemsHelper.getAllInventoryItems((LivingEntity)entity);
        if (!JikiHelper.hasEnoughIron((List)inventory, (float)5.0f)) {
            entity.func_145747_a((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_MATERIALS, Util.field_240973_b_);
            this.continuousComponent.stopContinuity(entity);
        } else {
            JikiHelper.spawnAttractEffect((Entity)entity);
        }
    }

    public int getMaxTriggers() {
        return 6;
    }

    public int getTriggerInterval() {
        return 4;
    }

    public float getProjectileSpeed() {
        return 2.5f;
    }

    public float getRepeaterCooldown() {
        return 240.0f;
    }

    public PunkPistolProjectile getProjectileFactory(LivingEntity entity) {
        List inventory = ItemsHelper.getAllInventoryItems((LivingEntity)entity);
        List components = JikiHelper.getMagneticItemsNeeded((List)inventory, (float)5.0f);
        PunkPistolProjectile proj = new PunkPistolProjectile(entity.field_70170_p, entity, components);
        proj.setDamage(25.0f);
        return proj;
    }
}

