/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.jikiextra;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class ReworkedPunkGibsonAbility
extends Ability {
    private static final int REQUIRED_IRON = 100;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"punk_gibson", (Pair[])new Pair[]{ImmutablePair.of((Object)"Uses %s magnetic items from the user's inventory to create a large arm increasing their punch power and reach.", (Object)new Object[]{"\u00a7a100\u00a7r"})});
    private static final int HOLD_TIME = 2400;
    private static final int MIN_COOLDOWN = 60;
    private static final int MAX_COOLDOWN = 600;
    public static final AbilityCore<ReworkedPunkGibsonAbility> INSTANCE = new AbilityCore.Builder("Punk Gibson", AbilityCategory.DEVIL_FRUITS, ReworkedPunkGibsonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)60.0f, (float)600.0f), ContinuousComponent.getTooltip((float)2400.0f), ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.METAL).setSourceType(new SourceType[]{SourceType.FIST}).build();
    private static final AbilityAttributeModifier PUNCH_DAMAGE_MODIFIER = new AbilityAttributeModifier(UUID.randomUUID(), INSTANCE, "Punk Gibson Strength Modifier", 6.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(UUID.randomUUID(), INSTANCE, "Punk Gibson Reach Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addTryHitEvent(this::hitEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private List<ItemStack> magneticItems = new ArrayList<ItemStack>();
    private boolean dropItems = true;

    public ReworkedPunkGibsonAbility(AbilityCore<ReworkedPunkGibsonAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.hitTriggerComponent, this.continuousComponent, this.statsComponent, this.morphComponent});
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)PUNCH_DAMAGE_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.addCanUseCheck(JikiHelper.getMetalicItemsCheck((int)100));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 2400.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.PUNK_GIBSON.get());
        this.statsComponent.applyModifiers(entity);
        if (!this.magneticItems.isEmpty()) {
            this.magneticItems.clear();
        }
        List inventory = ItemsHelper.getAllInventoryItems((LivingEntity)entity);
        this.magneticItems = JikiHelper.getMagneticItemsNeeded((List)inventory, (float)100.0f);
        this.dropItems = true;
        JikiHelper.spawnAttractEffect((Entity)entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.statsComponent.removeModifiers(entity);
        if (this.dropItems && this.magneticItems.size() > 0) {
            ItemStack stack = this.magneticItems.get(0);
            ItemsHelper.itemBreakParticles((LivingEntity)entity, (int)100, (ItemStack)stack);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187635_cQ, entity.func_184176_by(), 0.5f, 1.0f);
            JikiHelper.dropComponentItems((LivingEntity)entity, (Vector3d)entity.func_213303_ch(), this.magneticItems);
        }
        float cooldown = MathHelper.func_76131_a((float)this.continuousComponent.getContinueTime(), (float)60.0f, (float)600.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private HitTriggerComponent.HitResult hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            source.setSourceElement(SourceElement.METAL).setFistDamage();
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    public void activateDamnedPunk(LivingEntity entity) {
        this.statsComponent.removeModifiers(entity);
    }

    public void activatePunkGibson(LivingEntity entity) {
        this.statsComponent.applyModifiers(entity);
    }

    public void forceStart(LivingEntity entity) {
        this.continuousComponent.startContinuity(entity, 2400.0f);
    }

    public void stopItemDrops() {
        this.dropItems = false;
    }

    public List<ItemStack> getMagneticItems() {
        return this.magneticItems;
    }
}

