/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.jikiextra;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedPunkCornaDioAbility
extends Ability {
    private static final int REQUIRED_IRON = 160;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"punk_corna_dio", (Pair[])new Pair[]{ImmutablePair.of((Object)"Uses %s magnetic items from the inventory to create a bull which can then be used to smash into enemies dealing huge damage, knocking them away and potentially stunning them.", (Object)new Object[]{AbilityHelper.mentionText((Object)160)})});
    private static final int CHARGE_TIME = 60;
    private static final int HOLD_TIME = 100;
    private static final int COOLDOWN = 400;
    private static final int RANGE = 6;
    private static final float DAMAGE = 60.0f;
    public static final AbilityCore<ReworkedPunkCornaDioAbility> INSTANCE = new AbilityCore.Builder("Punk Corna Dio", AbilityCategory.DEVIL_FRUITS, ReworkedPunkCornaDioAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)340.0f), ChargeComponent.getTooltip((float)60.0f), DealDamageComponent.getTooltip((float)70.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.METAL).setSourceType(new SourceType[]{SourceType.BLUNT}).build();
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("bbdc5ee6-4e36-406b-b577-63939a9c05f8"), INSTANCE, "Punk Corna Dio Toughness Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_HEIGHT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("b9636d10-3ee1-4df5-b115-7b92c13fb777"), INSTANCE, "Punk Corna Dio Step Height Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    private List<ItemStack> magneticItems = new ArrayList<ItemStack>();
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public ReworkedPunkCornaDioAbility(AbilityCore<ReworkedPunkCornaDioAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.continuousComponent, this.hitTrackerComponent, this.rangeComponent, this.dealDamageComponent, this.morphComponent, this.changeStatsComponent});
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT_MODIFIER);
        this.addCanUseCheck(JikiHelper.getMetalicItemsCheck((int)160));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        List inventory = ItemsHelper.getAllInventoryItems((LivingEntity)entity);
        this.magneticItems = JikiHelper.getMagneticItemsNeeded((List)inventory, (float)160.0f);
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.PUNK_CORNA_DIO.get());
        this.changeStatsComponent.applyModifiers(entity);
        this.hitTrackerComponent.clearHits();
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 2, false, false));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 100.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 2, false, false));
        if (this.magneticItems.size() <= 0) {
            this.continuousComponent.stopContinuity(entity);
        }
        Vector3d lookVec = entity.func_70040_Z();
        Vector3d speed = lookVec.func_216372_d(2.3, 0.0, 2.3);
        entity.func_213315_a(MoverType.SELF, speed);
        if (this.continuousComponent.getContinueTime() % 25.0f == 0.0f) {
            this.hitTrackerComponent.clearHits();
        }
        Vector3d knockbackVec = lookVec.func_216372_d(4.0, 1.0, 4.0);
        List targets = this.rangeComponent.getTargetsInArea(entity, 6.0f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 70.0f)) continue;
            if (WyHelper.randomDouble() > 0.75) {
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 1, false, false));
            }
            AbilityHelper.setDeltaMovement((Entity)target, (double)knockbackVec.field_72450_a, (double)0.2, (double)knockbackVec.field_72449_c);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.magneticItems != null && this.magneticItems.size() > 0) {
            ItemStack stack = this.magneticItems.get(0);
            ItemsHelper.itemBreakParticles((LivingEntity)entity, (int)160, (ItemStack)stack);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_187635_cQ, entity.func_184176_by(), 0.5f, 1.0f);
            JikiHelper.dropComponentItems((LivingEntity)entity, (Vector3d)entity.func_213303_ch(), this.magneticItems);
        }
        this.morphComponent.stopMorph(entity);
        this.changeStatsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, 340.0f);
    }
}

