/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.jikiextra;

import java.awt.Color;
import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.jikiextra.ReworkedPunkGibsonAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedDamnedPunkAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"damned_punk", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the users arm into a rail-gun that shoots a projectile dealing massive damage on impact.", (Object)new Object[]{AbilityHelper.mentionText((Object)15)})});
    private static final int COOLDOWN = 400;
    public static final AbilityCore<ReworkedDamnedPunkAbility> INSTANCE = new AbilityCore.Builder("Damned Punk", AbilityCategory.DEVIL_FRUITS, ReworkedDamnedPunkAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)10.0f, (float)60.0f), ChargeComponent.getTooltip((float)60.0f), ContinuousComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)400.0f), RangeComponent.getTooltip((float)20.0f, (float)62.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.PUNK_GIBSON.get(), new MorphInfo[0]);
    private final MorphComponent morphComponent;
    private float range = 20.0f;
    private LightningEntity bolt;
    private Interval damageInterval = new Interval(10);

    public ReworkedDamnedPunkAbility(AbilityCore<ReworkedDamnedPunkAbility> core) {
        super(core);
        this.morphComponent = new MorphComponent((IAbility)this);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.dealDamageComponent, this.rangeComponent, this.chargeComponent, this.morphComponent, this.requireMorphComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        ReworkedPunkGibsonAbility abl = (ReworkedPunkGibsonAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedPunkGibsonAbility.INSTANCE);
        if (abl != null && !abl.isContinuous()) {
            return;
        }
        if (!this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 60.0f);
        } else if (this.chargeComponent.getChargePercentage() > 0.5f) {
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.range = 20.0f;
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.DAMNED_PUNK.get());
        ReworkedPunkGibsonAbility punkGibson = (ReworkedPunkGibsonAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedPunkGibsonAbility.INSTANCE);
        if (punkGibson != null && punkGibson.isContinuous()) {
            punkGibson.activateDamnedPunk(entity);
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.CHARGE_CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() == 39.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PRE_CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
        if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f) {
            this.range += 7.0f;
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 60.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            Vector3d hitVec;
            Direction dir;
            BlockRayTraceResult trace = WyHelper.rayTraceBlocks((Entity)entity, (double)0.25);
            if (this.bolt == null) {
                dir = Direction.func_176733_a((double)entity.field_70177_z);
                hitVec = trace.func_216347_e().func_72441_c((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
                this.bolt = new LightningEntity((Entity)entity, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, entity.field_70177_z, entity.field_70125_A, this.range, 10.0f, this.getCore());
                this.bolt.setColor(new Color(11693284));
                this.bolt.setMaxLife(200);
                this.bolt.setDamage(0.0f);
                this.bolt.setSize(0.4f);
                this.bolt.setBranches(1);
                this.bolt.setSegments(1);
                this.bolt.setLightningMimic(false);
                entity.field_70170_p.func_217376_c((Entity)this.bolt);
            } else {
                dir = Direction.func_176733_a((double)entity.field_70177_z);
                hitVec = trace.func_216347_e().func_72441_c((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
                this.bolt.func_70012_b(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            }
        }
        if (this.damageInterval.canTick()) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 3.0f, 2.0f);
            List list = this.rangeComponent.getTargetsInLine(entity, this.range, 3.5f);
            for (LivingEntity target : list) {
                this.dealDamageComponent.hurtTarget(entity, target, 10.0f);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.bolt != null) {
            this.bolt.func_70106_y();
            this.bolt = null;
        }
        this.morphComponent.stopMorph(entity);
        ReworkedPunkGibsonAbility punkGibson = (ReworkedPunkGibsonAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedPunkGibsonAbility.INSTANCE);
        if (punkGibson != null && punkGibson.isContinuous()) {
            punkGibson.activatePunkGibson(entity);
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }
}

