/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.inuwolf;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.init.CartI18n;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class ChasingPreyAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"chasing_prey", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user boosts their speed for a short amount of time, allowing them to chase their prey.", null)});
    public static final AbilityCore<ChasingPreyAbility> INSTANCE = new AbilityCore.Builder("Chasing Prey", AbilityCategory.DEVIL_FRUITS, ChasingPreyAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f, (float)480.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier STEP_ASSIST_MODIFIER = new AbilityAttributeModifier(UUID.fromString("576c0635-1783-4f3a-86f6-56cb680c3ab9"), INSTANCE, "Chasing Prey Step Assist Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::onConinuityTick).addEndEvent(this::stopContinuityEvent);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.WOLF_HEAVY.get(), new MorphInfo[]{(MorphInfo)CartMorphs.WOLF_WALK.get()});
    private final float MIN_COOLDOWN = 400.0f;
    private final float MAX_COOLDOWN = 480.0f;
    private final float HOLD_TIME = 80.0f;

    public ChasingPreyAbility(AbilityCore<ChasingPreyAbility> core) {
        super(core);
        this.isNew = true;
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_ASSIST_MODIFIER);
        this.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.continuousComponent, this.statsComponent});
        this.addUseEvent(this::useEvent);
    }

    private AbilityUseResult addCanUseCheck(LivingEntity entity, IAbility ability) {
        if ((double)entity.func_110143_aJ() < (double)entity.func_110138_aP() * 0.75) {
            TranslationTextComponent text = new TranslationTextComponent(CartI18n.ABILITY_HEAL_LOW, new Object[0]);
            return AbilityUseResult.fail((ITextComponent)text);
        }
        return AbilityUseResult.success();
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.continuousComponent.triggerContinuity(entity, 80.0f);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.applyModifiers(entity);
    }

    private void onConinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(1.2, 0.0, 1.2);
            entity.func_213315_a(MoverType.SELF, speed);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
    }

    public float getCooldownTicks() {
        return 400.0f + this.continuousComponent.getContinueTime();
    }
}

