/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.inuwolf;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.entities.projectiles.inuwolf.BigBadScratchProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class BigBadScratchAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"big_bad_scratch", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user scratches their foe, leaving them bleeding and stunned for a moment.", null)});
    private static final int COOLDOWN = 300;
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.WOLF_HEAVY.get(), new MorphInfo[]{(MorphInfo)CartMorphs.WOLF_WALK.get()});
    public static final AbilityCore<BigBadScratchAbility> INSTANCE = new AbilityCore.Builder("Big Bad Scratch", AbilityCategory.DEVIL_FRUITS, BigBadScratchAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).build();

    public BigBadScratchAbility(AbilityCore<BigBadScratchAbility> core) {
        super(core);
        this.continuousComponent.addStartEvent(100, this::onContinuityStart).addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::onContinuityEnd);
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.requireMorphComponent});
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 100, 0));
        target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0));
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_82175_bq) {
            this.projectileComponent.shoot(entity, 1.0f, 0.0f);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
    }

    public int getUseLimit() {
        return 1;
    }

    public float getPunchCooldown() {
        return 300.0f;
    }

    public boolean isParallel() {
        return false;
    }

    private BigBadScratchProjectile createProjectile(LivingEntity entity) {
        BigBadScratchProjectile proj = new BigBadScratchProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

