/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.inuokuchi;

import java.awt.Color;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartResources;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class KagamiyamaAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kagamiyama", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user coats themselves in a heavy armor of ice, increasing defense for a short while.", null)});
    private static final int HOLD_TIME = 300;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 700;
    public static final AbilityCore<KagamiyamaAbility> INSTANCE = new AbilityCore.Builder("Kagamiyama", AbilityCategory.DEVIL_FRUITS, KagamiyamaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)300.0f), CooldownComponent.getTooltip((float)100.0f, (float)700.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(UUID.fromString("20b97272-6418-4c71-91ec-33ce520105a8"), INSTANCE, "Kagamiyama Armor Modifier", 18.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0049efe7-b2c6-4357-8ff9-0c9f0da246b4"), INSTANCE, "Kagamiyama Armor Toughness Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("12ba7c3c-0cdf-4b08-9c85-6d7ab8ecf6c8"), INSTANCE, "Kagamiyama Toughness Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_BOOST_MODIFIER = new AbilityAttributeModifier(UUID.fromString("c636024a-7dae-4289-b6d6-dbf13e60dd1d"), INSTANCE, "Kagamiyama Jump Modifier", -1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier MOVEMENT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("a1a477c3-b9b3-4ce1-926d-bfb9e6ce0685"), INSTANCE, "Kagamiyama Movement Modifier", -0.15, AttributeModifier.Operation.ADDITION);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.BODY).setTexture(CartResources.KAGAMIYAMA).setColor(new Color(255, 255, 255, 165)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final SkinOverlayComponent skinOverlayComponent;
    private final ChangeStatsComponent changeStatsComponent;
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.OKUCHI_HEAVY.get(), new MorphInfo[0]);

    public KagamiyamaAbility(AbilityCore<KagamiyamaAbility> core) {
        super(core);
        this.skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);
        this.changeStatsComponent = new ChangeStatsComponent((IAbility)this);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.skinOverlayComponent, this.changeStatsComponent, this.requireMorphComponent});
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_BOOST_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)MOVEMENT_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.continuousComponent.triggerContinuity(entity, 300.0f);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
        this.skinOverlayComponent.showAll(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.PHYSICAL_MOVING_GUARD.get(), 2, 3, false, false));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        this.skinOverlayComponent.hideAll(entity);
        float cooldown = 100.0f + this.continuousComponent.getContinueTime() * 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

