/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.inuokuchi;

import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.inuokuchi.IcicleBarrageProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;

public class IcicleBarrageAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"icicle_barrage", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user produces and launches a barrage of icicles at their opponent.", null)});
    public static final AbilityCore<IcicleBarrageAbility> INSTANCE = new AbilityCore.Builder("Icicle Barrage", AbilityCategory.DEVIL_FRUITS, IcicleBarrageAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f)}).setSourceElement(SourceElement.ICE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true);
    private final RequireMorphComponent requireMorphComponent;
    private float cooldown = 400.0f;
    private int triggers = 3;
    private int interval = 10;

    public IcicleBarrageAbility(AbilityCore<IcicleBarrageAbility> core) {
        super(core);
        this.isNew = true;
        this.requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.OKUCHI_HEAVY.get(), new MorphInfo[]{(MorphInfo)CartMorphs.OKUCHI_WALK.get()});
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.requireMorphComponent});
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 7; ++i) {
                this.projectileComponent.shootWithSpread(living, 1.5f, 0.01f, 1);
            }
        });
        this.continuousComponent.addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityLimits::usingBrawler);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.cancelBrawler(entity)) {
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        IcicleBarrageProjectile projectile = new IcicleBarrageProjectile(entity.field_70170_p, entity);
        projectile.setDamage(projectile.getDamage());
        projectile.setMaxLife((int)((double)projectile.getMaxLife() * 0.9));
        return projectile;
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }
}

