/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.hoya;

import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.hoya.MajinAbility;
import net.MrMagicalCart.cartaddon.abilities.hoya.MajinFlightAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.OutOfBodyAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.PhysicalBodyEntity;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MajinControlAbility
extends OutOfBodyAbility<PhysicalBodyEntity> {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"majin_control", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user forms a genie from their stomach, allowing them to control it.", null)});
    private static final int HOLD_TIME = 3600;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 700;
    private static final AbilityAttributeModifier ARMOR_MODIFIER;
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER;
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER;
    private static final AbilityAttributeModifier REACH_MODIFIER;
    private static final AbilityAttributeModifier STRENGTH_MODIFIER;
    public static final AbilityCore<MajinControlAbility> INSTANCE;
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);

    public MajinControlAbility(AbilityCore<MajinControlAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.morphComponent, this.changeStatsComponent});
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER);
        this.continuousComponent.addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
        this.addCanUseCheck(this::hasMajin);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_213293_j(0.0, 5.0, 0.0);
        entity.field_70133_I = true;
        PhysicalBodyEntity body = new PhysicalBodyEntity(entity.field_70170_p);
        body.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        body.setOwner(entity);
        entity.field_70170_p.func_217376_c((Entity)body);
        body.setParentAbility((Ability)this);
        this.setOriginalBody((LivingEntity)body);
        this.changeStatsComponent.applyModifiers(entity);
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.MAJIN_CONTROL.get());
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_70644_a(Effects.field_76428_l) || entity.func_70660_b(Effects.field_76428_l).func_76459_b() <= 20) {
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 100, 0, false, false));
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MAJIN_PUFF.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        MajinFlightAbility flightAbility;
        IAbilityData abilityDataProps;
        this.changeStatsComponent.removeModifiers(entity);
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (flightAbility = (MajinFlightAbility)abilityDataProps.getPassiveAbility(MajinFlightAbility.INSTANCE)) != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)((PlayerEntity)entity));
        }
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime() / 6.0f);
        this.morphComponent.stopMorph(entity);
    }

    private AbilityUseResult hasMajin(LivingEntity entity, IAbility ability) {
        boolean majinActive;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        MajinAbility majinAbility = (MajinAbility)abilityProps.getEquippedAbility(MajinAbility.INSTANCE);
        boolean bl = majinActive = majinAbility != null && majinAbility.isContinuous();
        if (majinActive) {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), MajinAbility.INSTANCE.getUnlocalizedName()});
            return AbilityUseResult.fail((ITextComponent)text);
        }
        return AbilityUseResult.success();
    }

    public int getHoldTime() {
        return 3600;
    }

    public float getMaxRange() {
        return 80.0f;
    }

    public boolean isPhysical() {
        return true;
    }

    static {
        INSTANCE = new AbilityCore.Builder("Majin Control", AbilityCategory.DEVIL_FRUITS, MajinControlAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)700.0f), ContinuousComponent.getTooltip((float)3600.0f), ChangeStatsComponent.getTooltip()}).build();
        ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Majin Control Armor Modifier", 12.0, AttributeModifier.Operation.ADDITION);
        ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "Majin Control Armor Toughness Modifier", 6.0, AttributeModifier.Operation.ADDITION);
        TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Majin Control Toughness Modifier", 6.0, AttributeModifier.Operation.ADDITION);
        REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Majin Control Reach Modifier", 4.5, AttributeModifier.Operation.ADDITION);
        STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Majin Control Strength Modifier", 10.0, AttributeModifier.Operation.ADDITION);
    }
}

