/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.hoya;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MajinCheappoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"majin_cheappo", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user while on a budget, kicks the air beneath them to launch themselves into the air", null)});
    private static final int MIN_JUMPS = 1;
    private static final int MAX_JUMPS = 3;
    private static final float SHORT_COOLDOWN_PER_STACK = 10.0f;
    private static final float LONG_COOLDOWN_PER_STACK = 150.0f;
    private static final AbilityDescriptionLine.IDescriptionLine GEPPO_STACKS = (e, a) -> {
        if (a instanceof MajinCheappoAbility) {
            MajinCheappoAbility geppo = (MajinCheappoAbility)a;
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)StackComponent.STACKS_STAT, geppo.getMaxJumps(e), geppo.getMaxJumps(e));
            return statBuilder.build().getStatDescription();
        }
        return null;
    };
    public static final AbilityCore<MajinCheappoAbility> INSTANCE = new AbilityCore.Builder("Majin Cheappo", AbilityCategory.RACIAL, MajinCheappoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, AbilityHelper.createShortLongCooldownStat((float)10.0f, (float)150.0f), GEPPO_STACKS}).setHidden().build();
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GEPPO_LIKE, new AbilityPool2[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final StackComponent stackComponent = new StackComponent((IAbility)this);
    private boolean hasFallDamage = true;

    public MajinCheappoAbility(AbilityCore<MajinCheappoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.damageTakenComponent, this.stackComponent});
        this.setOGCD();
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        double ySpeed;
        Vector3d speed;
        this.stackComponent.setDefaultStacks(this.getMaxJumps(entity));
        int stacksUsedInt = 0;
        if (entity.func_70090_H()) {
            speed = WyHelper.propulsion((LivingEntity)entity, (double)2.0, (double)2.0, (double)2.0);
            ySpeed = speed.field_72448_b;
            stacksUsedInt = this.stackComponent.getStacks();
        } else {
            if (entity.func_233570_aj_()) {
                speed = WyHelper.propulsion((LivingEntity)entity, (double)4.5, (double)4.5);
                ySpeed = 1.35;
            } else {
                speed = WyHelper.propulsion((LivingEntity)entity, (double)1.65, (double)1.65);
                ySpeed = 1.025;
            }
            stacksUsedInt = 1;
        }
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)ySpeed, (double)speed.field_72449_c);
        this.stackComponent.addStacks(entity, (IAbility)this, -stacksUsedInt);
        this.hasFallDamage = false;
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GEPPO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + this.random.nextFloat() / 3.0f);
        if (this.stackComponent.getStacks() <= 0) {
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
            this.stackComponent.setStacks(entity, (IAbility)this, this.getMaxJumps(entity));
        } else {
            this.cooldownComponent.startCooldown(entity, 10.0f);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.resetStacks(entity);
            return 0.0f;
        }
        return damage;
    }

    public void tickEvent(LivingEntity entity, IAbility ability) {
        if (this.getLastUseGametime() <= 0L && this.stackComponent.getDefaultStacks() <= 0) {
            this.stackComponent.setDefaultStacks(this.getMaxJumps(entity));
            this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
        }
        if (!entity.field_70170_p.field_72995_K && !this.hasFallDamage && this.stackComponent.getStacks() < this.stackComponent.getDefaultStacks() && entity.func_233570_aj_() && entity.field_70170_p.func_82737_E() > this.getLastUseGametime() + 10L) {
            this.resetStacks(entity);
        }
    }

    private void resetStacks(LivingEntity entity) {
        if (this.stackComponent.getStacks() != this.stackComponent.getDefaultStacks()) {
            this.cooldownComponent.stopCooldown(entity);
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
        }
        this.stackComponent.setStacks(entity, (IAbility)this, this.getMaxJumps(entity));
        this.stackComponent.setDefaultStacks(this.getMaxJumps(entity));
        this.hasFallDamage = true;
    }

    private int getMaxJumps(LivingEntity entity) {
        return 4;
    }

    private float getCooldownTicks() {
        return (float)(this.stackComponent.getDefaultStacks() - this.stackComponent.getStacks()) * 150.0f;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
    }
}

