/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.hoya;

import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.abilities.hoya.MajinControlAbility;
import net.MrMagicalCart.cartaddon.entities.mobs.ability.MajinEntity;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class MajinAbility
extends Ability {
    private static final int HOLD_TIME = 12000;
    private static final int MIN_COOLDOWN = 40;
    private static final int MAX_COOLDOWN = 2000;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"majin", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user summons a genie that fights for them.", null)});
    public static final AbilityCore<MajinAbility> INSTANCE = new AbilityCore.Builder("Majin", AbilityCategory.DEVIL_FRUITS, MajinAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip(), CooldownComponent.getTooltip((float)40.0f, (float)2000.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::onTickEvent).addEndEvent(100, this::stopContinuityEvent);
    private final StackComponent stackComponent = new StackComponent((IAbility)this);
    private MajinEntity majin = null;

    public MajinAbility(AbilityCore<MajinAbility> core) {
        super(core);
        this.addCanUseCheck((entity, ability) -> {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), MajinControlAbility.INSTANCE.getUnlocalizedName()});
            return ((MorphInfo)CartMorphs.MAJIN_CONTROL.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)text) : AbilityUseResult.success();
        });
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.stackComponent});
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.majin = new MajinEntity(entity.field_70170_p, entity);
        this.majin.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        entity.field_70170_p.func_217376_c((Entity)this.majin);
    }

    private void onTickEvent(LivingEntity entity, IAbility ability) {
        if (this.majin == null || !this.majin.func_70089_S()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.majin != null) {
            this.majin.func_70106_y();
        }
        float cooldown = MathHelper.func_76131_a((float)this.continuousComponent.getContinueTime(), (float)40.0f, (float)2000.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    @Nullable
    public MajinEntity getMajin() {
        return this.majin;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        super.load(nbt);
    }
}

