/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.hitodaibutsuextra;

import java.util.ArrayList;
import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ZenImpactAbility
extends DropHitAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"zen_impact", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user leaps into the air and lands with their massive body.", null)});
    private static final float COOLDOWN = 300.0f;
    private static final float RANGE = 1.5f;
    private static final float DAMAGE = 70.0f;
    public static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate().testEnemyFaction().testSimpleInView();
    public static final AbilityCore<ZenImpactAbility> INSTANCE = new AbilityCore.Builder("Zen Impact", AbilityCategory.DEVIL_FRUITS, ZenImpactAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f), RangeComponent.getTooltip((float)9.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip((float)80.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.PHYSICAL}).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.HITO_DAIBUTSU_NEW.get(), new MorphInfo[0]);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(40);

    public ZenImpactAbility(AbilityCore<ZenImpactAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.dealDamageComponent, this.rangeComponent, this.animationComponent, this.requireMorphComponent});
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addEndEvent(100, this::endContinuityEvent).addTickEvent(100, this::tickContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = entity.func_70040_Z().func_186678_a(4.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)2.0, (double)speed.field_72449_c);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70143_R > 0.0f && !this.hasLanded()) {
            this.animationComponent.start(entity, ModAnimations.BELLY_FLOP);
            List targets = this.rangeComponent.getTargetsInArea(entity, 9.0f, TARGETS_PREDICATE);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                this.dealDamageComponent.hurtTarget(entity, target, 50.0f);
            }
            for (LivingEntity target : this.hitTrackerComponent.getHits()) {
                if (!(DevilFruitHelper.getDifferenceToFloor((Entity)target) > 1.5)) continue;
                target.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() - 1.0, entity.func_226281_cx_());
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    public void onLanding(LivingEntity entity) {
        for (Entity target : this.hitTrackerComponent.getHits()) {
            LivingEntity livingTarget;
            if (!(target instanceof LivingEntity) || !this.hitTrackerComponent.canHit((Entity)(livingTarget = (LivingEntity)target)) || !this.dealDamageComponent.hurtTarget(entity, livingTarget, 80.0f)) continue;
            livingTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
        }
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        int range = (int)Math.ceil(8.0);
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                double posX = entity.func_226277_ct_() + (double)x;
                double posY = entity.func_226278_cu_() - 1.0;
                double posZ = entity.func_226281_cx_() + (double)z;
                Vector3d pos = new Vector3d(posX, posY, posZ);
                positions.add(pos);
            }
        }
        if (positions.size() > 0) {
            this.details.setVecPositions(positions);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get()), (Entity)entity, (double)0.0, (double)0.0, (double)0.0, (ParticleEffect.Details)this.details);
        }
        this.continuousComponent.stopContinuity(entity);
    }
}

