/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.hitodaibutsuextra;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hitodaibutsu.ImpactBlastProjectile;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class ReworkedImpactBlastAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"impact_blast", (Pair[])new Pair[]{ImmutablePair.of((Object)"Launches a golden shock wave forward when punching an enemy or the air, hurting every entity in its path.", null)});
    private static final int COOLDOWN = 160;
    public static final AbilityCore<ReworkedImpactBlastAbility> INSTANCE = new AbilityCore.Builder("Impact Blast", AbilityCategory.DEVIL_FRUITS, ReworkedImpactBlastAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)360.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(new SourceType[]{SourceType.FIST}).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.HITO_DAIBUTSU_NEW.get(), new MorphInfo[0]);

    public ReworkedImpactBlastAbility(AbilityCore<ReworkedImpactBlastAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.requireMorphComponent});
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_82175_bq) {
            this.projectileComponent.shoot(entity, 2.0f, 0.0f);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private ImpactBlastProjectile createProjectile(LivingEntity entity) {
        ImpactBlastProjectile proj = new ImpactBlastProjectile(entity.field_70170_p, entity, (Ability)this);
        proj.setDamage(38.0f);
        proj.setMaxLife(12);
        return proj;
    }

    public float getPunchCooldown() {
        return 360.0f;
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        this.projectileComponent.shoot(entity, 2.5f, 0.0f);
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public int getUseLimit() {
        return 1;
    }
}

