/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.guraextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.particles.effects.guraextra.NewAirCrackParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShatteringLeapAbility
extends DropHitAbility {
    private static final NewAirCrackParticleEffect PARTICLES = new NewAirCrackParticleEffect();
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"shattering_leap", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user leaps into the air, and delivers a devastating crash to those below them. (Stuns for a brief moment, and applies dizzy)", null)});
    public static final AbilityCore<ShatteringLeapAbility> INSTANCE = new AbilityCore.Builder("Shattering Leap", AbilityCategory.DEVIL_FRUITS, ShatteringLeapAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)20.0f), CooldownComponent.getTooltip((float)300.0f), RangeComponent.getTooltip((float)4.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceElement(SourceElement.SHOCKWAVE).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private static final int COOLDOWN = 300;
    private static final float RANGE = 4.0f;
    private static final float DAMAGE = 20.0f;

    public ShatteringLeapAbility(AbilityCore<ShatteringLeapAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.morphComponent, this.dealDamageComponent, this.rangeComponent});
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
    }

    public void onLanding(LivingEntity entity) {
        this.morphComponent.stopMorph(entity);
        this.animationComponent.stop(entity);
        List targets = this.rangeComponent.getTargetsInArea(entity, 4.0f);
        targets.remove(entity);
        AbilityDamageSource source = (AbilityDamageSource)ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setFistDamage();
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !entity.func_70685_l((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 20.0f, (DamageSource)source)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 60));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10));
            AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
        }
        if (!entity.field_70170_p.field_72995_K) {
            if (targets.size() > 0) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
            PARTICLES.spawn((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 60.0, -90.0f, 0.0f);
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10));
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.0, (double)1.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)3.0, (double)speed.field_72449_c);
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.KAISHIN.get());
        this.animationComponent.start(entity, ModAnimations.RAISE_ARMS);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() >= 30.0f) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(1.25, 1.0, 1.25);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)-7.0, (double)speed.field_72449_c);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

