/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.guraextra;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.gura.AirCrackParticleEffect;

public class ReworkedKabutowariAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"kabutowari", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user grabs their opponent's head and concentrates their vibrations around it, resulting in crushing damage", null)});
    private static final AirCrackParticleEffect PARTICLES = new AirCrackParticleEffect();
    private static final int COOLDOWN = 200;
    private static final int CHARGE_TIME = 40;
    private static final int DAMAGE = 60;
    private static final int PULL_TIME = 200;
    public static final AbilityCore<ReworkedKabutowariAbility> INSTANCE = new AbilityCore.Builder("Kabutowari", AbilityCategory.DEVIL_FRUITS, ReworkedKabutowariAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f), ChargeComponent.getTooltip((float)40.0f), DealDamageComponent.getTooltip((float)60.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addEndEvent(this::onContinuityEnd);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, false, true, 1.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public ReworkedKabutowariAbility(AbilityCore<ReworkedKabutowariAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent, this.animationComponent, this.dealDamageComponent, this.continuousComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent});
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            if (this.continuousComponent.isContinuous()) {
                this.grabComponent.release(entity);
                this.continuousComponent.stopContinuity(entity);
            } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, 4.5f, 2.0f, false)) {
                this.grabComponent.triggerPulling(entity);
            } else {
                this.cooldownComponent.startCooldown(entity, 15.0f);
            }
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && !this.grabComponent.hasGrabbedEntity()) {
            if (this.grabComponent.grabManually(entity, target)) {
                this.grabComponent.startPulling(entity);
            }
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
            return false;
        }
        return true;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 40.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
                this.grabComponent.release(entity);
            }
            if (!this.grabComponent.canContinueGrab(entity)) {
                this.cooldownComponent.startCooldown(entity, 200.0f);
            }
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
            LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
            int chargeTime = (int)this.chargeComponent.getMaxChargeTime();
            if (grabbedTarget != null) {
                entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
                grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.SEISMIC_BUBBLE.get(), chargeTime, 0));
                AbilityHelper.setDeltaMovement((Entity)grabbedTarget, (double)0.0, (double)0.0, (double)0.0);
            }
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (!super.canUse(entity).isFail() && this.grabComponent.canContinueGrab(entity)) {
                LivingEntity target = this.grabComponent.getGrabbedEntity();
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
                Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.5, (double)(-target.func_70047_e()), (double)((double)target.func_213311_cf() - 0.2));
                AbilityHelper.setDeltaMovement((Entity)target, (Vector3d)pos.func_178788_d(target.func_213303_ch()), (boolean)true);
            } else {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.grabComponent.hasGrabbedEntity()) {
                LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
                ModDamageSource source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)super.getCore()).setPiercing(0.75f);
                this.dealDamageComponent.hurtTarget(entity, grabbedTarget, 60.0f, (DamageSource)source);
                ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)grabbedTarget.func_226277_ct_(), (double)grabbedTarget.func_226278_cu_(), (double)grabbedTarget.func_226281_cx_(), (float)2.0f);
                explosion.setStaticDamage(20.0f);
                explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(2));
                explosion.doExplosion();
                ItemStack stack = grabbedTarget.func_184582_a(EquipmentSlotType.HEAD);
                stack.func_222118_a(15, grabbedTarget, user -> user.func_213361_c(EquipmentSlotType.HEAD));
                PARTICLES.spawn(grabbedTarget.field_70170_p, grabbedTarget.func_226277_ct_(), grabbedTarget.func_226280_cw_(), grabbedTarget.func_226281_cx_(), 0.0, 0.0, 0.0);
                entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
                grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0));
                this.grabComponent.release(entity);
            }
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, 200.0f);
        }
    }
}

