/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.guraextra;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.particles.effects.guraextra.NewAirCrackParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class NewShingenNoIchigekiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"new_shingen_no_ichigeki", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user focuses vibrations around their fist in an spherical bubble, releasing when hitting an enemy and knocking them back.", null), ImmutablePair.of((Object)"The user focuses vibrations around their fist in an spherical bubble, releasing when hitting an enemy and knocking them into the air.", null)});
    private static final TranslationTextComponent STANDARD_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.shingen_no_ichigeki", (String)"Shingen no Ichigeki"));
    private static final TranslationTextComponent UPPERCUT_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.new_shingen_no_ichigeki_uppercut", (String)"Shingen no Ichigeki: Uppercut"));
    private static final ResourceLocation SHINGEN_NO_ICHIGEKI_STANDARD_ICON = new ResourceLocation("mineminenomi", "textures/abilities/shingen_no_ichigeki.png");
    private static final ResourceLocation SHINGEN_NO_ICHIGEKI_UPPERCUT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/shingen_no_ichigeki_uppercut.png");
    private static final float COOLDOWN = 200.0f;
    private static final float DAMAGE = 40.0f;
    private static final NewAirCrackParticleEffect PARTICLES = new NewAirCrackParticleEffect();
    public static final AbilityCore<NewShingenNoIchigekiAbility> INSTANCE = new AbilityCore.Builder("Shingen no Ichigeki", AbilityCategory.DEVIL_FRUITS, NewShingenNoIchigekiAbility::new).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> STANDARD_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip((float)200.0f), DealDamageComponent.getTooltip((float)40.0f)}).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> UPPERCUT_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip((float)200.0f), DealDamageComponent.getTooltip((float)40.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setSourceElement(SourceElement.SHOCKWAVE).build();
    private static final AbilityAttributeModifier PUNCH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0212c718-5539-42b6-88c0-292abf8a4eff"), INSTANCE, "Shingeki no Ichigeki Punch Damage Modifier", 40.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart).addTickEvent(this::duringContinuityEvent).addEndEvent(this::onContinuityEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(100, this::onHitTrigger);
    private final AltModeComponent<Mode> altModeComponent;
    private final ChangeStatsComponent statsComponent;
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private boolean markForStopping = false;

    public NewShingenNoIchigekiAbility(AbilityCore<NewShingenNoIchigekiAbility> core) {
        super(core);
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.STANDARD).addChangeModeEvent(this::onAltModeChange);
        this.statsComponent = new ChangeStatsComponent((IAbility)this);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.morphComponent, this.continuousComponent, this.hitTriggerComponent, this.altModeComponent, this.statsComponent});
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)PUNCH_MODIFIER);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.markForStopping = false;
        this.statsComponent.applyModifiers(entity);
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.SHINGEN_RIGHT.get());
        } else if (entity.func_184591_cq() == HandSide.LEFT) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.SHINGEN_LEFT.get());
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.markForStopping) {
            this.continuousComponent.stopContinuity(entity);
            this.markForStopping = false;
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.statsComponent.removeModifiers(entity);
        this.morphComponent.stopMorph(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private boolean onHitTrigger(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            Vector3d dirVec;
            this.markForStopping = true;
            source.setPiercing(0.75f).bypassLogia();
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_(), (float)2.0f);
            explosion.setStaticDamage(10.0f);
            explosion.setDestroyBlocks(false);
            explosion.setDamageEntities(false);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
            if (this.altModeComponent.getCurrentMode() == Mode.STANDARD) {
                dirVec = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_216372_d(2.0, 1.0, 2.0);
                AbilityHelper.setDeltaMovement((Entity)target, (double)(-dirVec.field_72450_a), (double)(0.5 + dirVec.field_72448_b), (double)(-dirVec.field_72449_c));
            }
            if (this.altModeComponent.getCurrentMode() == Mode.UPPERCUT) {
                dirVec = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_216372_d(1.025, 1.0, 1.025);
                AbilityHelper.setDeltaMovement((Entity)target, (double)(-dirVec.field_72450_a), (double)(1.75 + dirVec.field_72448_b), (double)(-dirVec.field_72449_c));
            }
            AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.9f);
            EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, (double)1.5);
            PARTICLES.spawn((Entity)entity, entity.field_70170_p, trace.func_216347_e().field_72450_a, trace.func_216347_e().field_72448_b, trace.func_216347_e().func_82616_c(), 48.0);
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 100, 0, false, false));
        }
        return true;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.STANDARD) {
            super.setDisplayIcon(SHINGEN_NO_ICHIGEKI_STANDARD_ICON);
        } else if (mode == Mode.UPPERCUT) {
            super.setDisplayIcon(SHINGEN_NO_ICHIGEKI_UPPERCUT_ICON);
        }
    }

    public static enum Mode {
        STANDARD,
        UPPERCUT;

    }
}

