/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.guraextra;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.particles.effects.guraextra.NewAirCrackParticleEffect;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NewShimaYurashiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"shima_yurashi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user grabs the air around them and pulls it downwards after which the nearby land and entities are sent flying.", null)});
    private static final int EXPLOSION_RADIUS = 27;
    private static final int EXPLOSION_DEPTH = 10;
    private static final int COOLDOWN = 1200;
    private static final int CHARGE_TIME = 100;
    private static final int MIN_DAMAGE = 66;
    private static final int MAX_DAMAGE = 80;
    private static final NewAirCrackParticleEffect PARTICLES = new NewAirCrackParticleEffect();
    public static final AbilityCore<NewShimaYurashiAbility> INSTANCE = new AbilityCore.Builder("Shima Yurashi", AbilityCategory.DEVIL_FRUITS, NewShimaYurashiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)1200.0f), ChargeComponent.getTooltip((float)100.0f), RangeComponent.getTooltip((float)27.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip((float)66.0f, (float)80.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    public List<FallingBlockEntity> entityBlocks = new ArrayList<FallingBlockEntity>();
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(40);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);

    public NewShimaYurashiAbility(AbilityCore<NewShimaYurashiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.morphComponent, this.chargeComponent, this.animationComponent, this.rangeComponent, this.dealDamageComponent});
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 100.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        List randomPositions = WyHelper.getNearbyBlocks((BlockPos)entity.func_233580_cy_(), (IWorld)entity.field_70170_p, (int)13, (List)ImmutableList.of((Object)Blocks.field_150350_a)).stream().filter(pos -> DefaultProtectionRules.CORE_FOLIAGE_ORE.check(entity.field_70170_p, pos, entity.field_70170_p.func_180495_p(pos))).collect(Collectors.toList());
        Collections.shuffle(randomPositions, entity.func_70681_au());
        this.details.clearPositions();
        this.entityBlocks = randomPositions.stream().limit(600L).map(pos -> {
            if (entity.field_70170_p.func_226660_f_(pos)) {
                this.details.addPosition(pos);
            }
            return new FallingBlockEntity(entity.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), entity.field_70170_p.func_180495_p(pos));
        }).collect(Collectors.toList());
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.KAISHIN.get());
        this.animationComponent.start(entity, ModAnimations.KAISHIN, 30);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GREAT_STOMP.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
        if (this.chargeComponent.getChargeTime() > 30.0f) {
            this.animationComponent.start(entity, ModAnimations.RAISE_ARMS);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0, false, false));
        List targets = this.rangeComponent.getTargetsInArea(entity, 27.0f);
        targets.stream().filter(target -> target != null && target.func_70089_S() && target.field_70170_p.func_217299_a(new RayTraceContext(target.func_213303_ch(), target.func_213303_ch().func_72441_c(0.0, -10.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)target)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)).forEach(target -> target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 10, 0, false, false)));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            List targets = this.rangeComponent.getTargetsInArea(entity, 27.0f);
            ModDamageSource source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this).setUnavoidable().bypassLogia().setPiercing(0.5f);
            targets.stream().filter(target -> target != null && target.func_70089_S() && entity.func_70685_l((Entity)target)).forEach(target -> {
                double distance = Math.min(66.0, Math.sqrt(target.func_70068_e((Entity)entity)));
                double damage = 80.0 - distance / 2.0;
                if (this.dealDamageComponent.hurtTarget(entity, target, (float)damage, (DamageSource)source) && target.func_233570_aj_()) {
                    Vector3d dirVec = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_216372_d(25.0, 1.0, 25.0);
                    AbilityHelper.setDeltaMovement((Entity)target, (double)(-dirVec.field_72450_a), (double)3.0, (double)(-dirVec.field_72449_c));
                }
            });
            for (FallingBlockEntity block : this.entityBlocks) {
                Vector3d dirVec = entity.func_213303_ch().func_178788_d(block.func_213303_ch()).func_72432_b().func_216372_d(2.0, 2.0, 2.0);
                block.func_70107_b((double)entity.func_233580_cy_().func_177958_n() + WyHelper.randomDouble() * 20.0, (double)entity.func_233580_cy_().func_177956_o() + WyHelper.randomDouble() * 3.0, (double)entity.func_233580_cy_().func_177952_p() + WyHelper.randomDouble() * 20.0);
                AbilityHelper.setDeltaMovement((Entity)block, (double)(-dirVec.field_72450_a), (double)(1.0 + dirVec.field_72448_b), (double)(-dirVec.field_72449_c));
                block.field_145813_c = false;
                block.field_145812_b = 1;
                entity.field_70170_p.func_217376_c((Entity)block);
            }
            int craterRadius = 72;
            AbilityHelper.createSphereWithProtection((World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (int)craterRadius, (int)10, (Block)Blocks.field_150350_a, (int)3, (BlockProtectionRule)DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
            this.morphComponent.stopMorph(entity);
            this.animationComponent.stop(entity);
            PARTICLES.spawn((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 300.0, -90.0f, 0.0f);
            this.cooldownComponent.startCooldown(entity, 1200.0f);
        }
    }
}

