/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.guraextra;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.entities.projectiles.guraextra.NewGekishinProjectile;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.particles.effects.guraextra.NewAirCrackParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.gura.AirCrackParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class NewGekishinAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"gekishin", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user 'cracks' the air, launching a single concentrated shockwave forward which send blocks flying and deals damage to all enemies in its path", null), ImmutablePair.of((Object)"The user 'cracks' the air on their sides, launching two smaller shockwaves which send blocks flying and deals damage to all enemies in their path", null)});
    private static final TranslationTextComponent GEKISHIN_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.gekishin", (String)"Gekishin"));
    private static final TranslationTextComponent KAISHIN_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.kaishin", (String)"Kaishin"));
    private static final ResourceLocation GEKISHIN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gekishin.png");
    private static final ResourceLocation KAISHIN_ICON = new ResourceLocation("mineminenomi", "textures/abilities/kaishin.png");
    private static final NewAirCrackParticleEffect PARTICLES = new NewAirCrackParticleEffect();
    private static final AirCrackParticleEffect PARTICLES2 = new AirCrackParticleEffect();
    private static final float GEKISHIN_COOLDOWN = 240.0f;
    private static final float GEKISHIN_CHARGE_TIME = 20.0f;
    private static final float KAISHIN_COOLDOWN = 480.0f;
    private static final float KAISHIN_CHARGE_TIME = 40.0f;
    public static final AbilityCore<NewGekishinAbility> INSTANCE = new AbilityCore.Builder("Gekishin", AbilityCategory.DEVIL_FRUITS, NewGekishinAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> GEKISHIN_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip((float)240.0f), ChargeComponent.getTooltip((float)20.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> KAISHIN_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip((float)480.0f), ChargeComponent.getTooltip((float)40.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).setSourceElement(SourceElement.SHOCKWAVE).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addEndEvent(this::onChargeEnd);
    private final AltModeComponent<Mode> altModeComponent;
    private final AnimationComponent animationComponent;
    private final ProjectileComponent projectileComponent;
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);

    public NewGekishinAbility(AbilityCore<NewGekishinAbility> core) {
        super(core);
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.GEKISHIN).addChangeModeEvent(this::onAltModeChange);
        this.animationComponent = new AnimationComponent((IAbility)this);
        this.projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.morphComponent, this.chargeComponent, this.altModeComponent, this.animationComponent, this.projectileComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.KAISHIN) {
            this.chargeComponent.startCharging(entity, 40.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.GEKISHIN) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.GEKISHIN) {
            this.animationComponent.start(entity, CartAnimations.GEKINSHIN);
            if (entity.func_184591_cq() == HandSide.RIGHT) {
                this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.SHINGEN_RIGHT.get());
            } else if (entity.func_184591_cq() == HandSide.LEFT) {
                this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.SHINGEN_LEFT.get());
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.KAISHIN) {
            this.animationComponent.start(entity, ModAnimations.KAISHIN);
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.KAISHIN.get());
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.morphComponent.stopMorph(entity);
            if (this.altModeComponent.getCurrentMode() == Mode.GEKISHIN) {
                EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, (double)1.5);
                PARTICLES.spawn((Entity)entity, entity.field_70170_p, trace.func_216347_e().field_72450_a, trace.func_216347_e().field_72448_b, trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
                entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
                this.projectileComponent.shoot(entity, 2.0f, 1.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.KAISHIN) {
                Vector3d v1 = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0).func_178787_e(entity.func_70040_Z().func_186678_a(2.5).func_178785_b(180.0f));
                Vector3d v2 = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0).func_178787_e(entity.func_70040_Z().func_186678_a(2.5).func_178785_b(-180.0f));
                PARTICLES2.spawn(entity.field_70170_p, v1.func_82615_a(), entity.func_226278_cu_() + 0.5, v1.func_82616_c(), 0.0, 0.0, 0.0);
                PARTICLES2.spawn(entity.field_70170_p, v2.func_82615_a(), entity.func_226278_cu_() + 0.5, v2.func_82616_c(), 0.0, 0.0, 0.0);
                double range = 8.0;
                List list = WyHelper.getNearbyEntities((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)range, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity), (Class[])new Class[]{Entity.class});
                for (Entity target : list) {
                    if (target instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)target).getDamage() < 20.0f && ((AbilityProjectileEntity)target).isPhysical()) {
                        target.func_70106_y();
                    }
                    if (!(target instanceof LivingEntity)) continue;
                    Vector3d speed = target.func_70040_Z().func_216372_d(3.0, 2.0, 3.0);
                    AbilityHelper.setDeltaMovement((Entity)target, (double)speed.field_72450_a, (double)speed.field_72448_b, (double)speed.field_72449_c);
                    target.field_70143_R = 0.0f;
                }
                entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 0.5f, 1.0f);
                NewGekishinProjectile p1 = (NewGekishinProjectile)this.projectileComponent.getNewProjectile(entity);
                p1.setMaxLife((int)((float)p1.getMaxLife() * 0.5f));
                entity.field_70170_p.func_217376_c((Entity)p1);
                p1.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z + 90.0f, 0.0f, 1.75f, 1.0f);
                NewGekishinProjectile p2 = (NewGekishinProjectile)this.projectileComponent.getNewProjectile(entity);
                p2.setMaxLife((int)((float)p2.getMaxLife() * 0.5f));
                entity.field_70170_p.func_217376_c((Entity)p2);
                p2.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z - 90.0f, 0.0f, 1.75f, 1.0f);
            }
            this.animationComponent.stop(entity);
            if (this.altModeComponent.getCurrentMode() == Mode.KAISHIN) {
                this.cooldownComponent.startCooldown(entity, 480.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.GEKISHIN) {
                this.cooldownComponent.startCooldown(entity, 240.0f);
            }
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (!this.chargeComponent.isCharging()) {
            if (mode == Mode.KAISHIN) {
                super.setDisplayName((ITextComponent)KAISHIN_NAME);
                super.setDisplayIcon(KAISHIN_ICON);
            } else if (mode == Mode.GEKISHIN) {
                super.setDisplayName((ITextComponent)GEKISHIN_NAME);
                super.setDisplayIcon(GEKISHIN_ICON);
            }
        }
    }

    private NewGekishinProjectile createProjectile(LivingEntity entity) {
        NewGekishinProjectile proj = new NewGekishinProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    public static enum Mode {
        GEKISHIN,
        KAISHIN;

    }
}

