/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.goru;

import net.MrMagicalCart.cartaddon.entities.projectiles.goru.GonFuocoDiDioProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GonFuocoDiDioAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"gon_fuoco_di_dio", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a powerful beam of energy from their eye at the opponent.", null)});
    private static final float CHARGE_TIME = 60.0f;
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<GonFuocoDiDioAbility> INSTANCE = new AbilityCore.Builder("Gon Fuoco Di Dio", AbilityCategory.DEVIL_FRUITS, GonFuocoDiDioAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHT).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent;

    public GonFuocoDiDioAbility(AbilityCore<GonFuocoDiDioAbility> core) {
        super(core);
        this.isNew = true;
        this.requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.GOLDEN_TESORO.get(), new MorphInfo[0]);
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.projectileComponent, this.animationComponent, this.requireMorphComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.CHARGE_CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() == 39.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PRE_CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.CHARGE_RADICAL_BEAM.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.CYBORG_BEAM_SFX.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, (double)80.0);
        double beamDistance = Math.sqrt(entity.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
        float damage = 90.0f;
        float size = 0.6f;
        float length = 70.0f;
        float extraY = 0.0f;
        if (MorphHelper.getZoanInfo((LivingEntity)entity) == CartMorphs.GOLDEN_TESORO.get()) {
            extraY = 10.0f;
        }
        Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.5, (double)1.15, (double)0.8);
        LightningEntity bolt = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b + (double)extraY, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A, length + (float)beamDistance, 10.0f, this.getCore());
        bolt.setBlocksAffectedLimit(4000);
        bolt.setMaxLife(60);
        bolt.setDamage(damage);
        bolt.setExplosion(6, true);
        bolt.setSize(size);
        bolt.setBoxSizeDivision(1.0);
        bolt.setColor(ElThorAbility.YELLOW_THUNDER);
        bolt.setAngle(100);
        bolt.setTargetTimeToReset(60);
        bolt.disableExplosionKnockback();
        bolt.setBranches(1);
        bolt.setSegments(1);
        entity.field_70170_p.func_217376_c((Entity)bolt);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private GonFuocoDiDioProjectile createProjectile(LivingEntity entity) {
        GonFuocoDiDioProjectile proj = new GonFuocoDiDioProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

