/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.goru;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.goru.GoldenTesoroAbility;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.goru.GonBombaProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class GonBombaAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"gon_bomba", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user makes a golden fist that explodes when they hit an entity or the air.", null), ImmutablePair.of((Object)"While the user is in their Golden Tesoro form, they can launch a golden shockwave that devastates everything within its path.", null)});
    private static final TranslationTextComponent GON_BOMBA_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.gon_bomba", "Gon Bomba"));
    private static final TranslationTextComponent GON_INFERNO_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.gon_inferno", "Gon Inferno"));
    private static final int COOLDOWN = 120;
    public static final AbilityCore<GonBombaAbility> INSTANCE = new AbilityCore.Builder("Gon Bomba", AbilityCategory.DEVIL_FRUITS, GonBombaAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> GON_BOMBA_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)25.0f), CooldownComponent.getTooltip((float)120.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> GON_INFERNO_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)45.0f), CooldownComponent.getTooltip((float)120.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);

    public GonBombaAbility(AbilityCore<? extends PunchAbility2> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.morphComponent});
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
        this.continuousComponent.addStartEvent(100, this::onContinuityStart);
        this.continuousComponent.addEndEvent(100, this::onContinuityEnd);
    }

    private GonBombaProjectile createProjectile(LivingEntity entity) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        GonBombaProjectile proj = new GonBombaProjectile(entity.field_70170_p, entity, (Ability)this);
        if (GonBombaAbility.hasGoldenTesoroActive(abilityDataProps)) {
            proj = new GonBombaProjectile(entity.field_70170_p, entity, (Ability)this, true);
        }
        return proj;
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        if (!GonBombaAbility.hasGoldenTesoroActive(abilityDataProps)) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.GON_BOMBA.get());
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        if (!GonBombaAbility.hasGoldenTesoroActive(abilityDataProps)) {
            this.morphComponent.stopMorph(entity);
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_82175_bq) {
            this.projectileComponent.shoot(entity, 2.0f, 0.0f);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    public float getPunchCooldown() {
        return 120.0f;
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        this.projectileComponent.shoot(entity, 2.0f, 0.0f);
        target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 50, 0));
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public boolean isParallel() {
        return false;
    }

    public int getUseLimit() {
        return 1;
    }

    public static boolean hasGoldenTesoroActive(IAbilityData props) {
        Ability ability = (Ability)props.getEquippedAbility(GoldenTesoroAbility.INSTANCE);
        boolean isActive = ability != null && ability.isContinuous();
        return isActive;
    }
}

