/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.goru;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.MrMagicalCart.cartaddon.init.CartResources;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class GoldenTouchAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"golden_touch", (Pair[])new Pair[]{ImmutablePair.of((Object)"Hit the target to encase them in gold.", null)});
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(CartResources.GOLDEN_BODY).setOverlayPart(AbilityOverlay.OverlayPart.LIMB).build();
    private static final int COOLDOWN = 400;
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);
    public static final AbilityCore<GoldenTouchAbility> INSTANCE = new AbilityCore.Builder("Golden Touch", AbilityCategory.DEVIL_FRUITS, GoldenTouchAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).build();

    public GoldenTouchAbility(AbilityCore<GoldenTouchAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.skinOverlayComponent});
        this.continuousComponent.addStartEvent(100, this::onContinuityStart).addEndEvent(100, this::onContinuityEnd);
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        target.func_195064_c(new EffectInstance((Effect)CartEffects.GOLDEN_STATUE.get(), 100, 0));
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    public int getUseLimit() {
        return 1;
    }

    public float getPunchCooldown() {
        return 400.0f;
    }

    public boolean isParallel() {
        return false;
    }
}

