/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.goru;

import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GoldenGuardAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"golden_guard", (Pair[])new Pair[]{ImmutablePair.of((Object)"Creates a shield of gold that protects the user from any attack.", null)});
    private static final int MAX_COOLDOWN = 400;
    public static final AbilityCore<GoldenGuardAbility> INSTANCE = new AbilityCore.Builder("Golden Guard", AbilityCategory.DEVIL_FRUITS, GoldenGuardAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(100, this::startContinuousEvent).addTickEvent(100, this::tickContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent;

    public GoldenGuardAbility(AbilityCore<GoldenGuardAbility> core) {
        super(core);
        this.addCanUseCheck((entity, ability) -> ((MorphInfo)CartMorphs.GOLDEN_TESORO.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)null) : AbilityUseResult.success());
        this.poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.animationComponent, this.poolComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 120.0f);
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(2.5);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 5, false, false));
        AbilityHelper.slowEntityFall((LivingEntity)entity);
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.GOLDEN_GUARD.get()), (Entity)entity, (double)(entity.func_226277_ct_() + look.field_72450_a), (double)(entity.func_226278_cu_() + 0.25 + look.field_72448_b), (double)(entity.func_226281_cx_() + look.field_72449_c));
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }
}

