/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.goru;

import java.awt.Color;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartResources;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class GoldenBodyAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"golden_body", (Pair[])new Pair[]{ImmutablePair.of((Object)"Allows the user's body to become gold, gaining slight strength and defence.", null)});
    private static final int HOLD_TIME = 400;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 500;
    public static final AbilityCore<GoldenBodyAbility> INSTANCE = new AbilityCore.Builder("Golden Body", AbilityCategory.DEVIL_FRUITS, GoldenBodyAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)100.0f, (float)500.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(UUID.fromString("66c54665-bd43-4ca5-b499-220cdb3bfd0e"), INSTANCE, "Golden Body Armor Modifier", 6.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("fd8caec6-366e-4222-958c-142193359243"), INSTANCE, "Golden Body Armor Toughness Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_MODIFIER = new AbilityAttributeModifier(UUID.fromString("530df526-d405-4789-96dd-d1b2db18d84b"), INSTANCE, "Golden Body Attack Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("541411af-68d0-4fbf-816d-ff5622c4e514"), INSTANCE, "Golden Body Toughness Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.BODY).setTexture(CartResources.GOLDEN_BODY).setColor(new Color(255, 255, 255, 165)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final SkinOverlayComponent skinOverlayComponent;
    private final ChangeStatsComponent changeStatsComponent;

    public GoldenBodyAbility(AbilityCore<GoldenBodyAbility> core) {
        super(core);
        this.addCanUseCheck((entity, ability) -> ((MorphInfo)CartMorphs.GOLDEN_TESORO.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)null) : AbilityUseResult.success());
        this.skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);
        this.changeStatsComponent = new ChangeStatsComponent((IAbility)this);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.skinOverlayComponent, this.changeStatsComponent});
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)ATTACK_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 400.0f);
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
        this.skinOverlayComponent.showAll(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.PHYSICAL_MOVING_GUARD.get(), 2, 3, false, false));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        this.skinOverlayComponent.hideAll(entity);
        float cooldown = 100.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

