/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.goroextra;

import java.awt.Color;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class ReworkedVariAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/vari.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/vari.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"vari", (Pair[])new Pair[]{ImmutablePair.of((Object)"A basic move where the user discharges variable amounts of electricity", null)});
    private static final ITextComponent ONE_MILLION_V_VARI_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.1_million_vari", (String)"1 Million Vari"));
    private static final ITextComponent TWENTY_MILLION_V_VARI_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.20_million_vari", (String)"20 Million Vari"));
    private static final ITextComponent ONE_HUNDRED_MILLION_V_VARI_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.100_million_vari", (String)"100 Million Vari"));
    private static final ITextComponent TWO_HUNDRED_MILLION_V_VARI_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.200_million_vari", (String)"200 Million Vari"));
    private static final int CHARGE_TIME = 20;
    public static final AbilityCore<ReworkedVariAbility> INSTANCE = new AbilityCore.Builder("Vari", AbilityCategory.DEVIL_FRUITS, ReworkedVariAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> ONE_MILLION_V_VARI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> CooldownComponent.getTooltip((float)Mode.ONE_MILLION_V.cooldown).expand(e, a), ChargeComponent.getTooltip((float)20.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> TWENTY_MILLION_V_VARI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> CooldownComponent.getTooltip((float)Mode.TWENTY_MILLION_V.cooldown).expand(e, a), ChargeComponent.getTooltip((float)20.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> ONE_HUNDRED_MILLION_V_VARI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> CooldownComponent.getTooltip((float)Mode.ONE_HUNDRED_MILLION_V.cooldown).expand(e, a), ChargeComponent.getTooltip((float)20.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> TWO_HUNDRED_MILLION_V_VARI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> CooldownComponent.getTooltip((float)Mode.TWO_HUNDRED_MILLION_V.cooldown).expand(e, a), ChargeComponent.getTooltip((float)20.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setIcon(DEFAULT_ICON).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, true).addStartEvent(100, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.ONE_MILLION_V).addChangeModeEvent(this::onAltModeChange);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final Interval dischargeInterval = new Interval(5);

    public ReworkedVariAbility(AbilityCore<ReworkedVariAbility> core) {
        super(core);
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent, this.altModeComponent, this.dealDamageComponent, this.animationComponent});
        super.addUseEvent(this::onUseEvent);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 20.0f);
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.dischargeInterval.restartIntervalToZero();
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.dischargeInterval.canTick()) {
            Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.5, (double)1.15, (double)0.8);
            float multi = 1.0f;
            if (((MorphInfo)ModMorphs.VOLT_AMARU.get()).isActive(entity)) {
                multi += 0.25f;
            }
            LightningDischargeEntity discharge = new LightningDischargeEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            discharge.setAliveTicks(5);
            discharge.setLightningLength(0.2f * multi);
            discharge.setColor(Color.WHITE);
            discharge.setOutlineColor(ClientConfig.INSTANCE.isGoroBlue() ? ElThorAbility.BLUE_THUNDER : ElThorAbility.YELLOW_THUNDER);
            discharge.setRenderTransparent();
            discharge.setDetails(20);
            discharge.setDensity(40);
            discharge.setSize(0.2f * multi);
            discharge.setSkipSegments(1);
            entity.field_70170_p.func_217376_c((Entity)discharge);
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            float multi = 1.0f;
            if (((MorphInfo)ModMorphs.VOLT_AMARU.get()).isActive(entity)) {
                multi += 0.25f;
            }
            ModDamageSource ablSource = AbilityDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setPiercing(0.75f).setUnavoidable();
            float radius = 12.0f * this.chargeComponent.getChargePercentage();
            Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.5, (double)1.15, (double)0.8);
            LightningDischargeEntity discharge = new LightningDischargeEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            discharge.setAliveTicks(15);
            discharge.setLightningLength(radius / 2.0f * multi);
            discharge.setColor(Color.WHITE);
            discharge.setOutlineColor(ClientConfig.INSTANCE.isGoroBlue() ? ElThorAbility.BLUE_THUNDER : ElThorAbility.YELLOW_THUNDER);
            discharge.setRenderTransparent();
            discharge.setDetails(20);
            discharge.setDensity(40);
            discharge.setSize(radius / 2.0f * multi);
            discharge.setSkipSegments(1);
            entity.field_70170_p.func_217376_c((Entity)discharge);
            List targets = WyHelper.getNearbyEntities((Vector3d)pos, (IWorld)entity.field_70170_p, (double)radius, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity), (Class[])new Class[]{LivingEntity.class});
            targets.remove(entity);
            Mode currentMode = (Mode)this.altModeComponent.getCurrentMode();
            for (LivingEntity target : targets) {
                float damage;
                if (!this.dealDamageComponent.hurtTarget(entity, target, (damage = (float)((double)(currentMode.getDamage() * this.chargeComponent.getChargePercentage()) * (1.0 - pos.func_72438_d(target.func_213303_ch()) / (double)(radius * 3.0f)))) * multi, (DamageSource)ablSource)) continue;
                target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 10, 0, false, false, true));
            }
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, currentMode.getCooldown());
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        super.setDisplayName(mode.getDisplayName());
    }

    static /* synthetic */ ITextComponent access$000() {
        return ONE_MILLION_V_VARI_NAME;
    }

    static /* synthetic */ ITextComponent access$100() {
        return TWENTY_MILLION_V_VARI_NAME;
    }

    static /* synthetic */ ITextComponent access$200() {
        return ONE_HUNDRED_MILLION_V_VARI_NAME;
    }

    static /* synthetic */ ITextComponent access$300() {
        return TWO_HUNDRED_MILLION_V_VARI_NAME;
    }

    public static enum Mode {
        ONE_MILLION_V(ReworkedVariAbility.access$000(), 10.0f, 200.0f),
        TWENTY_MILLION_V(ReworkedVariAbility.access$100(), 35.0f, 300.0f),
        ONE_HUNDRED_MILLION_V(ReworkedVariAbility.access$200(), 50.0f, 500.0f),
        TWO_HUNDRED_MILLION_V(ReworkedVariAbility.access$300(), 65.0f, 600.0f);

        private ITextComponent displayName;
        private float damage;
        private float cooldown;

        private Mode(ITextComponent displayName, float damage, float cooldown) {
            this.displayName = displayName;
            this.damage = damage;
            this.cooldown = cooldown;
        }

        public ITextComponent getDisplayName() {
            return this.displayName;
        }

        public float getDamage() {
            return this.damage;
        }

        public float getCooldown() {
            return this.cooldown;
        }
    }
}

