/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.goroextra;

import java.awt.Color;
import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.abilities.goroextra.ReworkedElThorAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedSangoAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/sango.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/sango.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"sango", (Pair[])new Pair[]{ImmutablePair.of((Object)"Launches powerful charges of electricity from the hands.", null)});
    private static final int COOLDOWN = 240;
    private static final int CHARGE_TIME = 40;
    public static final AbilityCore<ReworkedSangoAbility> INSTANCE = new AbilityCore.Builder("Sango", AbilityCategory.DEVIL_FRUITS, ReworkedSangoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f), ChargeComponent.getTooltip((float)40.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setIcon(DEFAULT_ICON).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final Interval particleInterval = new Interval(10);

    public ReworkedSangoAbility(AbilityCore<ReworkedSangoAbility> core) {
        super(core);
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent, this.animationComponent});
        super.addUseEvent(this::onUseEvent);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.particleInterval.restartIntervalToZero();
            this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.particleInterval.canTick()) {
            EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, (double)0.8);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.SANGO.get()), (Entity)entity, (double)trace.func_216347_e().func_82615_a(), (double)(entity.func_226278_cu_() + 1.0), (double)trace.func_216347_e().func_82616_c());
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, (double)32.0);
            double beamDistance = Math.sqrt(entity.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
            float multi = 1.0f;
            if (((MorphInfo)CartMorphs.VOLT_AMARU.get()).isActive(entity)) {
                multi += 0.25f;
            }
            float damage = 20.0f * multi;
            float size = 0.28f * multi;
            float length = 50.0f * multi;
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.5, (double)1.15, (double)0.8);
            LightningEntity boltInner = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A, length + (float)beamDistance, 20.0f, this.getCore());
            LightningEntity boltOuter = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A, length + (float)beamDistance, 20.0f, this.getCore());
            this.setBoltPropieties(boltInner, size * 0.9f, beamDistance, 0.0f, 25, false, Color.WHITE, multi);
            this.setBoltPropieties(boltOuter, size, beamDistance, damage, 40, true, ClientConfig.INSTANCE.isGoroBlue() ? ReworkedElThorAbility.BLUE_THUNDER : ReworkedElThorAbility.YELLOW_THUNDER, multi);
            boltOuter.seed = boltInner.seed;
            entity.field_70170_p.func_217376_c((Entity)boltInner);
            entity.field_70170_p.func_217376_c((Entity)boltOuter);
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, 240.0f);
        }
    }

    public void setBoltPropieties(LightningEntity bolt, float size, double distance, float damage, int timeAlive, boolean explodes, @Nullable Color color, float multiplier) {
        int segments = (int)(distance * 0.5);
        bolt.setBlocksAffectedLimit(1508);
        bolt.setMaxLife(40);
        bolt.setDamage(damage * multiplier);
        if (explodes) {
            bolt.setExplosion((int)(3.0f * multiplier), true, 0.3f);
        } else {
            bolt.setExplosion(0, false);
        }
        bolt.setSize(size * multiplier);
        bolt.setBoxSizeDivision((double)0.225f);
        bolt.setColor(color);
        bolt.setAngle(100);
        bolt.setTargetTimeToReset(60);
        bolt.disableExplosionKnockback();
        bolt.setBranches((int)(5.0 + distance / 100.0));
        bolt.setSegments((int)((double)segments + WyHelper.randomWithRange((int)(-segments / 4), (int)(segments / 4))));
    }
}

