/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.goroextra;

import java.awt.Color;
import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedElThorAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/el_thor.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/alts/el_thor.png");
    public static final Color YELLOW_THUNDER = new Color(-135916, true);
    public static final Color BLUE_THUNDER = WyHelper.hexToRGB((String)"#70EAFF22");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"el_thor", (Pair[])new Pair[]{ImmutablePair.of((Object)"Focuses a large cluster of electricity above the target, then sends a powerful lightning bolt crashing down from the sky", null)});
    private static final int CHARGE_TIME = 80;
    private static final int COOLDOWN = 480;
    public static final AbilityCore<ReworkedElThorAbility> INSTANCE = new AbilityCore.Builder("El Thor Reworked", AbilityCategory.DEVIL_FRUITS, ReworkedElThorAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)480.0f), ChargeComponent.getTooltip((float)80.0f)}).setSourceElement(SourceElement.LIGHTNING).setSourceHakiNature(SourceHakiNature.SPECIAL).setIcon(DEFAULT_ICON).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, component -> component.getChargeTime() >= 10.0f).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final Interval particleInterval = new Interval(2);

    public ReworkedElThorAbility(AbilityCore<ReworkedElThorAbility> core) {
        super(core);
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent, this.animationComponent});
        super.addUseEvent(this::onUseEvent);
        super.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 80.0f);
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.particleInterval.restartIntervalToZero();
            this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            AbilityHelper.slowEntityFall((LivingEntity)entity);
            if (this.particleInterval.canTick()) {
                RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)256.0, (float)0.4f);
                double i = mop.func_216347_e().field_72450_a;
                double j = mop.func_216347_e().field_72448_b;
                double k = mop.func_216347_e().field_72449_c;
                double particleAmount = this.chargeComponent.getChargeTime();
                int n = 0;
                while ((double)n < particleAmount) {
                    double offsetX = WyHelper.randomDouble() * (double)n * 0.225;
                    double offsetZ = WyHelper.randomDouble() * (double)n * 0.225;
                    if (entity instanceof PlayerEntity) {
                        WyHelper.spawnParticleEffectForOwner((ParticleEffect)((ParticleEffect)ModParticleEffects.EL_THOR_AIM.get()), (PlayerEntity)((PlayerEntity)entity), (double)(i + offsetX), (double)j, (double)(k + offsetZ), (ParticleEffect.Details)null);
                    }
                    ++n;
                }
            }
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            Vector3d mopPos;
            BlockRayTraceResult hitResult;
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity);
            double time = this.chargeComponent.getChargePercentage();
            float multi = (float)((double)0.4f + time * (double)0.6f);
            if (((MorphInfo)CartMorphs.VOLT_AMARU.get()).isActive(entity)) {
                multi += 0.25f;
            }
            float targetY = (hitResult = entity.field_70170_p.func_217299_a(new RayTraceContext(mopPos = mop.func_216347_e(), mopPos.func_72441_c(0.0, 128.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)entity))).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK) ? (float)hitResult.func_216347_e().field_72448_b : 128.0f;
            float travelLength = targetY + 16.0f * multi;
            Vector3d pos = new Vector3d(mopPos.field_72450_a, (double)targetY, mopPos.field_72449_c);
            LightningEntity boltInner = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 90.0f, travelLength, 24.0f, this.getCore());
            LightningEntity boltOuter = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 90.0f, travelLength, 24.0f, this.getCore());
            this.setBoltPropieties(boltInner, 2.0f, 0.0f, 90, 40, false, Color.WHITE, multi);
            this.setBoltPropieties(boltOuter, 2.5f, 50.0f, 100, 9999, true, ClientConfig.INSTANCE.isGoroBlue() ? BLUE_THUNDER : YELLOW_THUNDER, multi);
            boltOuter.seed = boltInner.seed;
            entity.field_70170_p.func_217376_c((Entity)boltInner);
            entity.field_70170_p.func_217376_c((Entity)boltOuter);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, new BlockPos(mopPos), (SoundEvent)ModSounds.EL_THOR_SFX.get(), SoundCategory.PLAYERS, 20.0f, 1.0f);
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, 480.0f);
        }
    }

    public void setBoltPropieties(LightningEntity bolt, float size, float damage, int timeAlive, int resetTime, boolean explodes, @Nullable Color color, float multiplier) {
        bolt.setBlocksAffectedLimit(8150);
        bolt.setAngle(160);
        bolt.setBranches(1);
        bolt.setSegments(1);
        bolt.setSize(size * multiplier);
        bolt.setBoxSizeDivision((double)0.225f);
        bolt.setLightningMovement(false);
        bolt.setExplosion(explodes ? (int)(10.0f * multiplier) : 0, true, 0.25f);
        if (color != null) {
            bolt.setColor(color);
        }
        bolt.setMaxLife(timeAlive);
        bolt.setDamage(damage * multiplier);
        bolt.setTargetTimeToReset(resetTime);
    }
}

