/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.generic;

import java.util.ArrayList;
import java.util.List;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.PacifistaMarkTwoEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ImprovedBellyFlopAbility
extends DropHitAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"improved_belly_flop", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user jumps in the air and uses their whole body to hit all the targets while falling, targets hit on ground will also get dizzy and is knocked out for a few seconds.", null)});
    private static final float COOLDOWN = 300.0f;
    private static final float RANGE = 1.5f;
    private static final float DAMAGE = 30.0f;
    public static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate().testEnemyFaction().testSimpleInView();
    public static final AbilityCore<ImprovedBellyFlopAbility> INSTANCE = new AbilityCore.Builder("Improved Belly Flop", AbilityCategory.STYLE, ImprovedBellyFlopAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f), RangeComponent.getTooltip((float)1.5f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip((float)45.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.PHYSICAL}).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(40);

    public ImprovedBellyFlopAbility(AbilityCore<ImprovedBellyFlopAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.dealDamageComponent, this.rangeComponent, this.animationComponent});
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addEndEvent(100, this::endContinuityEvent).addTickEvent(100, this::tickContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = entity.func_70040_Z();
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)1.5, (double)speed.field_72449_c);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70143_R > 0.0f && !this.hasLanded()) {
            this.animationComponent.start(entity, ModAnimations.BELLY_FLOP);
            List targets = this.rangeComponent.getTargetsInArea(entity, 1.5f, TARGETS_PREDICATE);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                this.dealDamageComponent.hurtTarget(entity, target, 15.0f);
            }
            for (LivingEntity target : this.hitTrackerComponent.getHits()) {
                if (!(DevilFruitHelper.getDifferenceToFloor((Entity)target) > 1.5)) continue;
                target.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() - 1.0, entity.func_226281_cx_());
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    public void onLanding(LivingEntity entity) {
        for (Entity target : this.hitTrackerComponent.getHits()) {
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0, false, false));
            this.dealDamageComponent.hurtTarget(entity, livingTarget, 25.0f);
            livingTarget.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 20, 0, false, false));
        }
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        int range = (int)Math.ceil(1.5);
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                double posX = entity.func_226277_ct_() + (double)x;
                double posY = entity.func_226278_cu_() - 1.0;
                double posZ = entity.func_226281_cx_() + (double)z;
                Vector3d pos = new Vector3d(posX, posY, posZ);
                positions.add(pos);
            }
        }
        if (positions.size() > 0) {
            this.details.setVecPositions(positions);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get()), (Entity)entity, (double)0.0, (double)0.0, (double)0.0, (ParticleEffect.Details)this.details);
        }
        this.continuousComponent.stopContinuity(entity);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return entity instanceof PacifistaMarkTwoEntity;
        }
        return false;
    }
}

