/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.generic;

import net.MrMagicalCart.cartaddon.config.CartCommonConfig;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CheappoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"cheappo", (Pair[])new Pair[]{ImmutablePair.of((Object)"Geppo... but CHEAP!", null)});
    private static final int MIN_JUMPS = 1;
    private static final int MAX_JUMPS = 4;
    private static final float SHORT_COOLDOWN_PER_STACK = 10.0f;
    private static final float LONG_COOLDOWN_PER_STACK = 70.0f;
    private static final AbilityDescriptionLine.IDescriptionLine GEPPO_STACKS = (e, a) -> {
        if (a instanceof CheappoAbility) {
            CheappoAbility geppo = (CheappoAbility)a;
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)StackComponent.STACKS_STAT, geppo.getMaxJumps(e), geppo.getMaxJumps(e));
            return statBuilder.build().getStatDescription();
        }
        return null;
    };
    public static final AbilityCore<CheappoAbility> INSTANCE = new AbilityCore.Builder("Cheappo", AbilityCategory.RACIAL, CheappoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, AbilityHelper.createShortLongCooldownStat((float)10.0f, (float)70.0f), GEPPO_STACKS}).setUnlockCheck(CheappoAbility::canUnlock).build();
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GEPPO_LIKE, new AbilityPool2[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this).addOnAttackEvent(this::onDamageTaken);
    private final StackComponent stackComponent = new StackComponent((IAbility)this);
    private boolean hasFallDamage = true;

    public CheappoAbility(AbilityCore<CheappoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.damageTakenComponent, this.stackComponent});
        this.setOGCD();
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        double ySpeed;
        Vector3d speed;
        this.stackComponent.setDefaultStacks(this.getMaxJumps(entity));
        int stacksUsed = 0;
        if (entity.func_70090_H()) {
            speed = WyHelper.propulsion((LivingEntity)entity, (double)2.0, (double)2.0, (double)2.0);
            ySpeed = speed.field_72448_b;
            stacksUsed = this.stackComponent.getStacks();
        } else {
            if (entity.func_233570_aj_()) {
                speed = WyHelper.propulsion((LivingEntity)entity, (double)1.0, (double)1.0);
                ySpeed = 1.86;
            } else {
                speed = WyHelper.propulsion((LivingEntity)entity, (double)1.5, (double)1.5);
                ySpeed = 1.25;
            }
            stacksUsed = 1;
        }
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)ySpeed, (double)speed.field_72449_c);
        this.stackComponent.addStacks(entity, (IAbility)this, -stacksUsed);
        this.hasFallDamage = false;
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GEPPO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + this.random.nextFloat() / 3.0f);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GEPPO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        if (this.stackComponent.getStacks() <= 0) {
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
            this.stackComponent.setStacks(entity, (IAbility)this, this.getMaxJumps(entity));
        } else {
            this.cooldownComponent.startCooldown(entity, 10.0f);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.resetStacks(entity);
            return 0.0f;
        }
        return damage;
    }

    public void tickEvent(LivingEntity entity, IAbility ability) {
        if (this.getLastUseGametime() <= 0L && this.stackComponent.getDefaultStacks() <= 0) {
            this.stackComponent.setDefaultStacks(this.getMaxJumps(entity));
            this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
        }
        if (!entity.field_70170_p.field_72995_K && !this.hasFallDamage && this.stackComponent.getStacks() < this.stackComponent.getDefaultStacks() && entity.func_233570_aj_() && entity.field_70170_p.func_82737_E() > this.getLastUseGametime() + 10L) {
            this.resetStacks(entity);
        }
    }

    private void resetStacks(LivingEntity entity) {
        if (this.stackComponent.getStacks() != this.stackComponent.getDefaultStacks()) {
            this.cooldownComponent.stopCooldown(entity);
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
        }
        this.stackComponent.setStacks(entity, (IAbility)this, this.getMaxJumps(entity));
        this.stackComponent.setDefaultStacks(this.getMaxJumps(entity));
        this.hasFallDamage = true;
    }

    private int getMaxJumps(LivingEntity entity) {
        boolean raceCheck;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean bl = raceCheck = props.getRace().equals((Object)CartValues.ONI) || props.getRace().equals((Object)CartValues.LUNARIAN);
        if (raceCheck) {
            return 3;
        }
        return 4;
    }

    private float getCooldownTicks() {
        return (float)(this.stackComponent.getDefaultStacks() - this.stackComponent.getStacks()) * 70.0f;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
    }

    private static boolean canUnlock(LivingEntity user) {
        if (!CartCommonConfig.INSTANCE.cheappoEnabled()) {
            return false;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean raceCheck = !props.isHuman();
        return raceCheck && props.getDoriki() >= 2000.0;
    }
}

