/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.fishmankarateextra;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanKarateHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate.YarinamiProjectile;

public class ReworkedYarinamiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"yarinami", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user fires a densely compressed spear-shaped waterbullet at the opponent", null)});
    private static final float COOLDOWN = 240.0f;
    private static final float CHARGE_TIME = 60.0f;
    private static final float WATER_DAMAGE_MUL = 1.2f;
    public static final AbilityCore<ReworkedYarinamiAbility> INSTANCE = new AbilityCore.Builder("Yarinami", AbilityCategory.RACIAL, ReworkedYarinamiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f), ChargeComponent.getTooltip((float)60.0f), FishmanKarateHelper.getWaterBuffedProjectileDamageStat((float)1.2f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.WATER).setUnlockCheck(ReworkedYarinamiAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addEndEvent(100, this::onEndChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public ReworkedYarinamiAbility(AbilityCore<ReworkedYarinamiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.projectileComponent});
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void onEndChargeEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 3.5f, 0.0f);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private YarinamiProjectile createProjectile(LivingEntity entity) {
        YarinamiProjectile proj = new YarinamiProjectile(entity.field_70170_p, entity);
        if (FishmanKarateHelper.isInWater((LivingEntity)entity)) {
            proj.setDamage(proj.getDamage() * 1.2f);
        }
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isFishman() && props.getDoriki() >= 6500.0;
    }
}

