/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.fishmankarateextra;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanKarateHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.fishmankarate.UchimizuProjectile;

public class ReworkedUchimizuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"uchimizu", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user hurls big and fast water droplets at the opponent", null)});
    private static final float COOLDOWN = 80.0f;
    private static final float WATER_DAMAGE_MUL = 2.0f;
    public static final AbilityCore<ReworkedUchimizuAbility> INSTANCE = new AbilityCore.Builder("Uchimizu", AbilityCategory.RACIAL, ReworkedUchimizuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)80.0f), FishmanKarateHelper.getWaterBuffedProjectileDamageStat((float)2.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.WATER).setUnlockCheck(ReworkedUchimizuAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(100, this::startContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(100, this::onRepeaterTriggerEvent).addStopEvent(100, this::onRepeaterStopEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public ReworkedUchimizuAbility(AbilityCore<ReworkedUchimizuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.repeaterComponent, this.projectileComponent});
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            this.continuousComponent.startContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 8, 3);
    }

    private void onRepeaterTriggerEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 3.5f, 1.0f);
    }

    private void onRepeaterStopEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 80.0f);
    }

    private UchimizuProjectile createProjectile(LivingEntity entity) {
        UchimizuProjectile proj = new UchimizuProjectile(entity.field_70170_p, entity);
        proj.setDamage(7.0f);
        if (FishmanKarateHelper.isInWater((LivingEntity)entity)) {
            proj.setDamage(proj.getDamage() * 2.0f);
        }
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isFishman() && props.getDoriki() >= 500.0;
    }
}

