/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.fishmankarateextra;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class ReworkedTwoFishEngineAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"two_fish_engine", (Pair[])new Pair[]{ImmutablePair.of((Object)"Increases the user's swimming speed", null)});
    private static final float HOLD_TIME = 200.0f;
    private static final float MIN_COOLDOWN = 100.0f;
    private static final float MAX_COOLDOWN = 300.0f;
    public static final AbilityCore<ReworkedTwoFishEngineAbility> INSTANCE = new AbilityCore.Builder("Two Fish Engine", AbilityCategory.RACIAL, ReworkedTwoFishEngineAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)300.0f), ContinuousComponent.getTooltip((float)200.0f), ChangeStatsComponent.getTooltip()}).setUnlockCheck(ReworkedTwoFishEngineAbility::canUnlock).build();
    private static final AbilityAttributeModifier SWIN_SPEED = new AbilityAttributeModifier(UUID.fromString("ea4d8827-cd16-447a-b9fa-7d0931b52629"), INSTANCE, "Fishman Speed Modifier", 1.75, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(100, this::onEndContinuousEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);

    public ReworkedTwoFishEngineAbility(AbilityCore<ReworkedTwoFishEngineAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.statsComponent});
        this.statsComponent.addAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), (AttributeModifier)SWIN_SPEED, entity -> this.continuousComponent.isContinuous());
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void onEndContinuousEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime());
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isFishman() && props.getDoriki() >= 2000.0;
    }
}

