/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.fishmankarateextra;

import net.MrMagicalCart.cartaddon.entities.projectiles.fishmankarateextra.ReworkedMizuTaihoProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanKarateHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedMizuTaihoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"mizu_taiho", (Pair[])new Pair[]{ImmutablePair.of((Object)"Launches a giant bubble, dealing massive damage and exploding on contact.", null)});
    private static final int COOLDOWN = 400;
    private static final int CHARGE_TIME = 30;
    public static final AbilityCore<ReworkedMizuTaihoAbility> INSTANCE = new AbilityCore.Builder("Mizu Taiho", AbilityCategory.RACIAL, ReworkedMizuTaihoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f), ChargeComponent.getTooltip((float)30.0f), FishmanKarateHelper.getWaterBuffedProjectileDamageStat((float)1.25f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setUnlockCheck(ReworkedMizuTaihoAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargeEvent).addEndEvent(100, this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public ReworkedMizuTaihoAbility(AbilityCore<ReworkedMizuTaihoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.projectileComponent, this.animationComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 30.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.MIZU_TAIHO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(1.5 + entity.func_226278_cu_()), (double)entity.func_226281_cx_());
        this.animationComponent.stop(entity);
        this.projectileComponent.shoot(entity, 2.0f, 0.0f);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private ReworkedMizuTaihoProjectile createProjectile(LivingEntity entity) {
        ReworkedMizuTaihoProjectile projectile = new ReworkedMizuTaihoProjectile(entity.field_70170_p, entity);
        if (FishmanKarateHelper.isInWater((LivingEntity)entity)) {
            projectile.setDamage(projectile.getDamage() * 1.25f);
        }
        return projectile;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isFishman() && props.getDoriki() >= 8000.0;
    }
}

