/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.fishmankarateextra;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedMizuOsuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"mizu_osu", (Pair[])new Pair[]{ImmutablePair.of((Object)"Spits water with enough force to push away any enemy in front of the user.", null)});
    private static final int COOLDOWN = 160;
    private static final float RANGE = 2.0f;
    public static final AbilityCore<ReworkedMizuOsuAbility> INSTANCE = new AbilityCore.Builder("Mizu Osu", AbilityCategory.RACIAL, ReworkedMizuOsuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)160.0f), RangeComponent.getTooltip((float)2.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setUnlockCheck(ReworkedMizuOsuAbility::canUnlock).build();
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);

    public ReworkedMizuOsuAbility(AbilityCore<ReworkedMizuOsuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.rangeComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List targets = this.rangeComponent.getTargetsInLine(entity, 2.0f, 2.0f);
        for (LivingEntity target : targets) {
            Vector3d diff = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_186678_a(4.0);
            AbilityHelper.setDeltaMovement((Entity)target, (double)diff.field_72450_a, (double)0.2, (double)diff.field_72449_c);
        }
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.MIZU_OSU.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(1.75 + entity.func_226278_cu_()), (double)entity.func_226281_cx_());
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isFishman();
    }
}

