/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.fishmankarateextra;

import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanKarateHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedKarakusagawaraSeikenAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"karakusagawara_seiken", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user punches the air, which sends a shockwave through water vapor in the air", null)});
    private static final float COOLDOWN = 500.0f;
    private static final float CHARGE_TIME = 40.0f;
    private static final float RANGE = 10.0f;
    private static final float DAMAGE = 50.0f;
    private static final float WATER_DAMAGE_MUL = 1.75f;
    public static final AbilityCore<ReworkedKarakusagawaraSeikenAbility> INSTANCE = new AbilityCore.Builder("Karakusagawara Seiken", AbilityCategory.RACIAL, ReworkedKarakusagawaraSeikenAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)500.0f), ChargeComponent.getTooltip((float)30.0f), FishmanKarateHelper.getWaterBuffedDamageStat((float)50.0f, (float)1.75f), RangeComponent.getTooltip((float)6.5f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceElement(SourceElement.SHOCKWAVE).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(ReworkedKarakusagawaraSeikenAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startTickEvent).addTickEvent(100, this::onTickChargeEvent).addEndEvent(100, this::onEndChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public ReworkedKarakusagawaraSeikenAbility(AbilityCore<ReworkedKarakusagawaraSeikenAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.chargeComponent, this.rangeComponent, this.dealDamageComponent});
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 30.0f);
    }

    private void startTickEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CHARGE_PUNCH);
    }

    private void onTickChargeEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.KARAKUSAGAWARA_SEIKEN_CHARGING.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
    }

    private void onEndChargeEvent(LivingEntity entity, IAbility ability) {
        List targets = this.rangeComponent.getTargetsInLine(entity, 6.5f, 4.0f);
        AbilityDamageSource source = (AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity);
        source.setUnavoidable();
        source.setInternal();
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LivingEntity target;
            float finalDamage = 50.0f * (!(target = (LivingEntity)iterator.next()).func_70090_H() && !FishmanKarateHelper.isInWater((LivingEntity)entity) ? 1.0f : 1.75f);
            if (!this.dealDamageComponent.hurtTarget(entity, target, finalDamage, (DamageSource)source)) continue;
            Vector3d dirVec = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_216372_d(2.5, 1.0, 2.5);
            AbilityHelper.setDeltaMovement((Entity)target, (double)dirVec.field_72450_a, (double)0.2, (double)dirVec.field_72449_c);
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 1));
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.MIZU_OSU.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(1.75 + entity.func_226278_cu_()), (double)entity.func_226281_cx_());
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isFishman() && props.getDoriki() >= 9500.0;
    }
}

