/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.enma;

import net.MrMagicalCart.cartaddon.entities.projectiles.enma.BlackBladeHellSlashProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class BlackBladeHellSlashAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"black_blade_hell_slash", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user sends a short ranged devastating slash.", null)});
    private static final float COOLDOWN = 300.0f;
    public static final AbilityCore<BlackBladeHellSlashAbility> INSTANCE = new AbilityCore.Builder("Black Blade: Hell Slash", AbilityCategory.EQUIPMENT, BlackBladeHellSlashAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).setUnlockCheck(BlackBladeHellSlashAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public BlackBladeHellSlashAbility(AbilityCore<BlackBladeHellSlashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent});
        this.addUseEvent(this::onUseEvent);
        super.addEquipEvent(this::equipEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_184614_ca().func_77973_b().equals(ModWeapons.ENMA.get()) && !entity.func_184592_cb().func_77973_b().equals(ModWeapons.ENMA.get())) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding Enma in either hand to use this move!"), entity.func_110124_au());
            return;
        }
        this.projectileComponent.shoot(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private BlackBladeHellSlashProjectile createProjectile(LivingEntity entity) {
        BlackBladeHellSlashProjectile proj = new BlackBladeHellSlashProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        return BlackBladeHellSlashAbility.hasItem(entity);
    }

    private static boolean hasItem(LivingEntity entity) {
        for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
            if (!itemStack.func_77973_b().equals(ModWeapons.ENMA.get())) continue;
            return true;
        }
        return false;
    }
}

