/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.electroextra;

import java.awt.Color;
import java.util.UUID;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartEleclawAbility;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartElectroHelper;
import net.MrMagicalCart.cartaddon.entities.mobs.CartOfficerEntity;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartSulongAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"sulong", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user reveals their true power during the night, enhancing their physical and electrical power. While active %s stacks are not consumed. Can be used during all non new moon nights or while having a rumble ball eaten. Be careful holding this ability with rumble balls, since past one minute it starts to wear down on you.", (Object)new Object[]{AbilityHelper.mentionAbility(CartEleclawAbility.INSTANCE)})});
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 1200;
    private static final Color COLOR = WyHelper.hexToRGB((String)"#B0E9F255");
    public static final AbilityCore<CartSulongAbility> INSTANCE = new AbilityCore.Builder("Sulong", AbilityCategory.RACIAL, CartSulongAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)2500.0f), ContinuousComponent.getTooltip((float)3600.0f, (float)12000.0f), ChangeStatsComponent.getTooltip()}).setUnlockCheck(CartSulongAbility::canUnlock).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.BODY).setColor(COLOR).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0b6d004a-d30e-4eec-9900-ac56f8d34c2c"), INSTANCE, "Sulong Speed Modifier", 0.09, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("a0c74dd2-9e6e-450b-9e71-125aa4dca62d"), INSTANCE, "Sulong Attack Damage Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0e9a63d0-d466-457b-a473-69652b8dcbf5"), INSTANCE, "Sulong Jump Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_HEIGHT = new AbilityAttributeModifier(UUID.fromString("6ec90ae9-1125-4fad-ac11-15b6011d7cd0"), INSTANCE, "Sulong Step Height Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final SkinOverlayComponent skinOverlayComponent;
    private final StackComponent stackComponent = new StackComponent((IAbility)this, 0);
    private boolean rumbleBall = false;

    public CartSulongAbility(AbilityCore<CartSulongAbility> core) {
        super(core);
        this.skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.stackComponent, this.damageTakenComponent, this.continuousComponent, this.statsComponent, this.skinOverlayComponent});
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233823_f_, (AttributeModifier)STRENGTH_MODIFIER);
        this.statsComponent.addAttributeModifier((Attribute)ModAttributes.JUMP_HEIGHT.get(), (AttributeModifier)JUMP_MODIFIER);
        this.statsComponent.addAttributeModifier((Attribute)ModAttributes.STEP_HEIGHT.get(), (AttributeModifier)STEP_HEIGHT);
        this.addCanUseCheck(CartElectroHelper::canTransformInSulong);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70644_a((Effect)CartEffects.RUMBLE.get())) {
            this.continuousComponent.triggerContinuity(entity, 3600.0f);
            this.rumbleBall = true;
        } else {
            this.continuousComponent.triggerContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.applyModifiers(entity);
        this.skinOverlayComponent.showAll(entity);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && CartElectroHelper.canTransformInSulong(entity, ability).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (this.rumbleBall && this.continuousComponent.getContinueTime() >= 1200.0f && this.continuousComponent.getContinueTime() % 600.0f == 0.0f) {
            this.stackComponent.addStacks(entity, (IAbility)this, 1);
        }
        if (this.stackComponent.getStacks() >= 5) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 200));
        }
        if (this.stackComponent.getStacks() >= 4) {
            entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 300, 0));
            entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 300, 0));
        }
        if (this.stackComponent.getStacks() >= 3) {
            entity.func_195064_c(new EffectInstance(Effects.field_76438_s, 300, 2));
        }
        if (this.stackComponent.getStacks() >= 2) {
            entity.func_195064_c(new EffectInstance(Effects.field_76419_f, 300, 0));
        }
        if (this.stackComponent.getStacks() >= 1) {
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 1));
        }
        if (entity instanceof CartOfficerEntity) {
            entity.func_195064_c(new EffectInstance(Effects.field_76424_c, 5, 1, false, false));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.stackComponent.revertStacksToDefault(entity, ability);
        this.statsComponent.removeModifiers(entity);
        this.skinOverlayComponent.hideAll(entity);
        float holdTime = this.continuousComponent.getContinueTime();
        if (holdTime >= 2400.0f) {
            holdTime = 2400.0f;
        }
        this.cooldownComponent.startCooldown(entity, 100.0f + holdTime);
        this.rumbleBall = false;
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isMink() && props.getDoriki() >= 1200.0;
    }
}

