/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.electroextra;

import java.util.UUID;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartEleclawAbility;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartSulongAbility;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.MrMagicalCart.cartaddon.init.CartI18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyPatreon;

public class CartElectroHelper {
    public static final UUID SULONG_DAMAGE_BONUS = UUID.fromString("d3db868d-e995-4661-bc24-09e40027b26b");
    public static final UUID SULONG_COOLDOWN_BONUS = UUID.fromString("4333ec98-1da6-40b0-905f-e771994f1db5");
    public static final UUID SULONG_RANGE_BONUS = UUID.fromString("da22fb88-7ffd-49de-ac60-6de118d2fe71");

    public static AbilityUseResult canTransformInSulong(LivingEntity entity, IAbility ability) {
        if (!(entity instanceof PlayerEntity)) {
            return AbilityUseResult.success();
        }
        return !CartElectroHelper.canTransform(entity.field_70170_p, entity) ? AbilityUseResult.fail((ITextComponent)CartI18n.ABILITY_MESSAGE_NEED_ANY_MOON) : AbilityUseResult.success();
    }

    public static Ability.ICanUseEvent<LivingEntity, IAbility> requireEleclaw(int neededStacks) {
        return (entity, ability) -> {
            CartEleclawAbility eleclaw = (CartEleclawAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(CartEleclawAbility.INSTANCE);
            if (eleclaw != null && eleclaw.isContinuous()) {
                int eleclawStacks = eleclaw.getComponent(ModAbilityKeys.STACK).map(comp -> comp.getStacks()).orElse(0);
                if (eleclawStacks - neededStacks < 0) {
                    TranslationTextComponent message = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_ABILITY_STACKS, new Object[]{neededStacks, CartEleclawAbility.INSTANCE.getLocalizedName().getString()});
                    return AbilityUseResult.fail((ITextComponent)message);
                }
                return AbilityUseResult.success();
            }
            return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NEED_ELECLAW);
        };
    }

    public static boolean hasSulongActive(LivingEntity entity) {
        CartSulongAbility sulong = (CartSulongAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(CartSulongAbility.INSTANCE);
        return sulong != null && sulong.isContinuous();
    }

    public static boolean canTransform(World world, LivingEntity player) {
        if (WyDebug.isDebug() && WyPatreon.BUILD_MODE == WyPatreon.BuildMode.DEV && world.func_226690_K_()) {
            return true;
        }
        return WyHelper.isInChallengeDimension((World)world) || player.func_70644_a((Effect)CartEffects.RUMBLE.get()) || world.func_230315_m_().func_236035_c_(world.func_72820_D()) != 4 && !world.func_72896_J() && !world.func_230315_m_().func_236037_d_() && world.func_230315_m_().func_218272_d() && world.func_226690_K_();
    }
}

