/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.electroextra;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartEleclawAbility;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartElectroHelper;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartSulongAbility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.events.passives.MinkPassiveEvents;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartElectricalTempestaAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.5f;
    private static final float DAMAGE_BONUS = 2.0f;
    private static final float RANGE_BONUS = 2.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"electrical_tempesta", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user releases a charge of energy that deals damage to nearby enemies and knocks them back.", null), ImmutablePair.of((Object)"While %s is active the cooldown of this ability is reduced by %s, the damage is increased by %s and the range of the ability is increased by %s.", (Object)new Object[]{AbilityHelper.mentionAbility(CartSulongAbility.INSTANCE), AbilityHelper.mentionText((Object)(Math.round(50.0f) + "%")), AbilityHelper.mentionText((Object)(Math.round(Math.abs(-1.0f) * 100.0f) + "%")), AbilityHelper.mentionText((Object)(Math.round(Math.abs(-1.0f) * 100.0f) + "%"))})});
    private static final int COOLDOWN = 160;
    private static final int CHARGE_TIME = 10;
    private static final int RANGE = 10;
    private static final int DAMAGE = 20;
    private static final int ELECLAW_STACKS = 1;
    public static final AbilityCore<CartElectricalTempestaAbility> INSTANCE = new AbilityCore.Builder("Electrical Tempesta", AbilityCategory.RACIAL, CartElectricalTempestaAbility::new).addDescriptionLine(new ITextComponent[]{DESCRIPTION[0]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)DESCRIPTION[1])}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)160.0f), ChargeComponent.getTooltip((float)10.0f), RangeComponent.getTooltip((float)8.0f, (float)10.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip((float)20.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(CartElectricalTempestaAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private LightningDischargeEntity ballEntity = null;

    public CartElectricalTempestaAbility(AbilityCore<CartElectricalTempestaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.rangeComponent, this.dealDamageComponent});
        this.addCanUseCheck(CartElectroHelper.requireEleclaw(1));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 10.0f);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        if (this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.ELECTRO_CHARGING.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
        if (this.ballEntity == null) {
            LightningDischargeEntity ball = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
            entity.field_70170_p.func_217376_c((Entity)ball);
            this.ballEntity = ball;
        } else {
            float distance = 0.5f;
            Vector3d lookVec = entity.func_70040_Z();
            double px = entity.func_226277_ct_() + lookVec.field_72450_a * (double)distance;
            double py = entity.func_226278_cu_() + lookVec.field_72450_a * (double)distance;
            double pz = entity.func_226281_cx_() + lookVec.field_72449_c * (double)distance;
            Vector3d pos = new Vector3d(px, py, pz);
            float percentage = 1.0f - this.chargeComponent.getChargeTime() / this.chargeComponent.getMaxChargeTime();
            this.ballEntity.setSize(percentage * 0.1f);
            this.ballEntity.setLightningLength(2.0f);
            this.ballEntity.func_70012_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), entity.field_70177_z, entity.field_70125_A);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            boolean hasSulongActive = CartElectroHelper.hasSulongActive(entity);
            this.dealDamageComponent.getBonusManager().removeBonus(CartElectroHelper.SULONG_DAMAGE_BONUS);
            this.rangeComponent.getBonusManager().removeBonus(CartElectroHelper.SULONG_RANGE_BONUS);
            this.cooldownComponent.getBonusManager().removeBonus(CartElectroHelper.SULONG_COOLDOWN_BONUS);
            if (hasSulongActive) {
                this.dealDamageComponent.getBonusManager().addBonus(CartElectroHelper.SULONG_DAMAGE_BONUS, "Sulong Damage Bonus", BonusOperation.MUL, 2.0f);
                this.rangeComponent.getBonusManager().addBonus(CartElectroHelper.SULONG_RANGE_BONUS, "Sulong Range Bonus", BonusOperation.MUL, 2.0f);
                this.cooldownComponent.getBonusManager().addBonus(CartElectroHelper.SULONG_COOLDOWN_BONUS, "Sulong Cooldown Bonus", BonusOperation.MUL, 0.5f);
            }
            if (this.ballEntity != null) {
                this.ballEntity.func_70106_y();
                this.ballEntity = null;
            }
            for (int i = 0; i < 3; ++i) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.ELECTRICAL_TEMPESTA_2.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            }
            float horizontal = 8.0f;
            if (entity.func_70090_H()) {
                horizontal = 10.0f;
            }
            float vertical = 3.0f;
            List targets = WyHelper.getNearbyLiving((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)horizontal, (double)vertical, (double)horizontal, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity));
            ModDamageSource source = (ModDamageSource)this.dealDamageComponent.getDamageSource(entity);
            for (LivingEntity target : targets) {
                if (!this.dealDamageComponent.hurtTarget(entity, target, 20.0f, (DamageSource)source)) continue;
                Vector3d dirVec = entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b();
                target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 10, 0, false, false, true));
                AbilityHelper.setDeltaMovement((Entity)target, (double)(-dirVec.field_72450_a * 4.0), (double)1.0, (double)(-dirVec.field_72449_c * 4.0));
            }
            int amount = 32;
            for (int j = 0; j < amount; ++j) {
                float boltSize = (float)WyHelper.randomWithRange((int)3, (int)((int)horizontal));
                LightningEntity bolt = new LightningEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (float)WyHelper.randomWithRange((int)0, (int)360), (float)WyHelper.randomWithRange((int)0, (int)5), boltSize, 8.0f, this.getCore());
                bolt.setColor(MinkPassiveEvents.MINK_LIGHTNING_COLOR);
                bolt.setAngle(60);
                bolt.setMaxLife(20);
                bolt.setDamage(0.0f);
                bolt.setExplosion(0, false);
                bolt.setSize(boltSize / 600.0f);
                bolt.setBranches((int)WyHelper.randomWithRange((int)1, (int)3));
                bolt.setSegments((int)((double)boltSize * 0.6));
                bolt.setLightningMimic(false);
                entity.field_70170_p.func_217376_c((Entity)bolt);
            }
            CartEleclawAbility eleclaw = (CartEleclawAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(CartEleclawAbility.INSTANCE);
            if (eleclaw != null) {
                eleclaw.reduceUsage(entity, 1);
            }
            this.cooldownComponent.startCooldown(entity, 160.0f);
        }
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isMink() && props.getDoriki() >= 3000.0;
    }
}

