/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.electroextra;

import net.MrMagicalCart.cartaddon.abilities.electroextra.CartEleclawAbility;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartElectroHelper;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartSulongAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.electro.CartElectricalShowerProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartElectricalShowerAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.3f;
    private static final float DAMAGE_BONUS = 1.25f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"electrical_shower", (Pair[])new Pair[]{ImmutablePair.of((Object)"Launches the user into the air and showers down lightning bolts underneath.", null), ImmutablePair.of((Object)"While %s is active the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{AbilityHelper.mentionAbility(CartSulongAbility.INSTANCE), AbilityHelper.mentionText((Object)(Math.round(70.0f) + "%")), AbilityHelper.mentionText((Object)(Math.round(Math.abs(-0.25f) * 100.0f) + "%"))})});
    private static final int COOLDOWN = 240;
    private static final int CHARGE_TIME = 60;
    private static final int DAMAGE = 20;
    private static final int ELECLAW_STACKS = 2;
    public static final AbilityCore<CartElectricalShowerAbility> INSTANCE = new AbilityCore.Builder("Electrical Shower", AbilityCategory.RACIAL, CartElectricalShowerAbility::new).addDescriptionLine(new ITextComponent[]{DESCRIPTION[0]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)DESCRIPTION[1])}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f), ChargeComponent.getTooltip((float)60.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(CartElectricalShowerAbility::canUnlock).build();
    private final StackComponent stackComponent = new StackComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::triggerRepeaterEvent).addStopEvent(this::stopRepeaterEvent);
    private LightningDischargeEntity ballEntity = null;
    boolean hasFallDamage = true;

    public CartElectricalShowerAbility(AbilityCore<CartElectricalShowerAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.stackComponent, this.chargeComponent, this.damageTakenComponent, this.projectileComponent, this.continuousComponent, this.repeaterComponent});
        this.addCanUseCheck(CartElectroHelper.requireEleclaw(2));
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
        } else {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        Vector3d startVec;
        boolean blockUnder;
        entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 2, 0, false, false, false));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.ELECTRO_CHARGING.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
        float percentage = 1.0f - this.chargeComponent.getChargeTime() / this.chargeComponent.getMaxChargeTime();
        if (this.ballEntity == null) {
            LightningDischargeEntity ball;
            this.ballEntity = ball = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        } else {
            float distance = percentage * 2.0f;
            Vector3d lookVec = entity.func_70040_Z();
            double px = entity.func_226277_ct_() + lookVec.field_72450_a * (double)distance;
            double py = entity.func_226280_cw_() * 0.85 + lookVec.field_72448_b * (double)distance;
            double pz = entity.func_226281_cx_() + lookVec.field_72449_c * (double)distance;
            Vector3d pos = new Vector3d(px, py, pz);
            this.ballEntity.setSize(percentage * 0.3f);
            this.ballEntity.setLightningLength(3.0f);
            this.ballEntity.func_70012_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), entity.field_70177_z, entity.field_70125_A);
        }
        if ((double)percentage > 0.65 && (blockUnder = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec = entity.func_213303_ch(), startVec.func_72441_c(0.0, -15.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)) && entity instanceof PlayerEntity) {
            AbilityHelper.setDeltaMovement((Entity)entity, (double)entity.func_213322_ci().field_72450_a, (double)1.0, (double)entity.func_213322_ci().field_72449_c);
        }
        AbilityHelper.slowEntityFall((LivingEntity)entity);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        CartEleclawAbility eleclaw;
        if (this.ballEntity != null) {
            this.ballEntity.func_70106_y();
            this.ballEntity = null;
        }
        if ((eleclaw = (CartEleclawAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(CartEleclawAbility.INSTANCE)) != null) {
            eleclaw.reduceUsage(entity, 2);
        }
        this.continuousComponent.startContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        this.repeaterComponent.start(entity, 10, 5);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 2, 2, false, false, false));
        AbilityHelper.slowEntityFall((LivingEntity)entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 5.0f, 2.0f);
        entity.func_226292_a_(Hand.MAIN_HAND, true);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.LIGHTNING_TELEPORT.get(), SoundCategory.PLAYERS, 3.0f, 1.55f);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private CartElectricalShowerProjectile createProjectile(LivingEntity entity) {
        CartElectricalShowerProjectile proj = new CartElectricalShowerProjectile(entity.field_70170_p, entity);
        if (!(entity instanceof PlayerEntity)) {
            proj.setGravity(0.06f);
            proj.setMaxLife(20);
        }
        proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 0.0f);
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isMink() && props.getDoriki() >= 7000.0;
    }
}

