/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.electroextra;

import net.MrMagicalCart.cartaddon.abilities.electroextra.CartEleclawAbility;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartElectroHelper;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartSulongAbility;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DashAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class CartElectricalMissileAbility
extends DashAbility {
    private static final float COOLDOWN_BONUS = 0.5f;
    private static final float DAMAGE_BONUS = 2.5f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"electrical_missile", (Pair[])new Pair[]{ImmutablePair.of((Object)"Powerful and fast forward dash that will stun enemies.", null), ImmutablePair.of((Object)"While %s is active the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{AbilityHelper.mentionAbility(CartSulongAbility.INSTANCE), AbilityHelper.mentionText((Object)(Math.round(50.0f) + "%")), AbilityHelper.mentionText((Object)(Math.round(Math.abs(-1.5f) * 100.0f) + "%"))})});
    private static final int COOLDOWN = 100;
    private static final float RANGE = 1.6f;
    private static final int DAMAGE = 20;
    private static final int ELECLAW_STACKS = 1;
    public static final AbilityCore<CartElectricalMissileAbility> INSTANCE = new AbilityCore.Builder("Electrical Missile", AbilityCategory.RACIAL, CartElectricalMissileAbility::new).addDescriptionLine(new ITextComponent[]{DESCRIPTION[0]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)DESCRIPTION[1])}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f), RangeComponent.getTooltip((float)1.6f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip((float)20.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(CartElectricalMissileAbility::canUnlock).build();
    private double dashSpeed = 4.0;

    public CartElectricalMissileAbility(AbilityCore<CartElectricalMissileAbility> core) {
        super(core);
        this.addCanUseCheck(CartElectroHelper.requireEleclaw(1));
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        boolean hasSulongActive = CartElectroHelper.hasSulongActive(entity);
        double d = this.dashSpeed = hasSulongActive ? 4.5 : 3.5;
        if (entity.func_70090_H()) {
            this.dashSpeed = hasSulongActive ? 3.5 : 2.5;
        }
        this.dealDamageComponent.getBonusManager().removeBonus(CartElectroHelper.SULONG_DAMAGE_BONUS);
        this.cooldownComponent.getBonusManager().removeBonus(CartElectroHelper.SULONG_COOLDOWN_BONUS);
        if (hasSulongActive) {
            this.dealDamageComponent.getBonusManager().addBonus(CartElectroHelper.SULONG_DAMAGE_BONUS, "Sulong Damage Bonus", BonusOperation.MUL, 2.5f);
            this.cooldownComponent.getBonusManager().addBonus(CartElectroHelper.SULONG_COOLDOWN_BONUS, "Sulong Cooldown Bonus", BonusOperation.MUL, 0.5f);
        }
        entity.func_226292_a_(Hand.MAIN_HAND, true);
        CartEleclawAbility cartEleclawAbility = (CartEleclawAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(CartEleclawAbility.INSTANCE);
        if (cartEleclawAbility != null) {
            cartEleclawAbility.reduceUsage(entity, 1);
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.LIGHTNING_TELEPORT.get(), SoundCategory.PLAYERS, 3.0f, 1.15f);
    }

    public void onTargetHit(LivingEntity entity, LivingEntity target, float damage, DamageSource source) {
        target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 40, 0, false, false, true));
    }

    public float getDashCooldown() {
        return 100.0f;
    }

    public float getDamage() {
        return 20.0f;
    }

    public float getRange() {
        return 1.6f;
    }

    public double getSpeed() {
        return this.dashSpeed;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isMink() && props.getDoriki() >= 800.0;
    }
}

