/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.electroextra;

import net.MrMagicalCart.cartaddon.abilities.electroextra.CartEleclawAbility;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartElectroHelper;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartSulongAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.electro.CartElectricalLunaProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartElectricalLunaAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.3f;
    private static final float DAMAGE_BONUS = 2.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"electrical_luna", (Pair[])new Pair[]{ImmutablePair.of((Object)"Charges a lightning ball in the user's hand which will be used whenever the user swings their arm, shooting the ball of electricity towards their target. On impact the ball will cause a small area of effect that stuns all nearby enemies but only damages the main target.", null), ImmutablePair.of((Object)"While %s is active the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{AbilityHelper.mentionAbility(CartSulongAbility.INSTANCE), AbilityHelper.mentionText((Object)(Math.round(70.0f) + "%")), AbilityHelper.mentionText((Object)(Math.round(Math.abs(-1.0f) * 100.0f) + "%"))})});
    private static final int COOLDOWN = 200;
    private static final int CHARGE_TIME = 30;
    public static final int RANGE = 6;
    private static final int DAMAGE = 40;
    private static final int ELECLAW_STACKS = 2;
    public static final AbilityCore<CartElectricalLunaAbility> INSTANCE = new AbilityCore.Builder("Electrical Luna", AbilityCategory.RACIAL, CartElectricalLunaAbility::new).addDescriptionLine(new ITextComponent[]{DESCRIPTION[0]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.IDescriptionLine.of((ITextComponent)DESCRIPTION[1])}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f), ChargeComponent.getTooltip((float)30.0f), RangeComponent.getTooltip((float)6.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(CartElectricalLunaAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addEndEvent(this::endContinuityEvent);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent((IAbility)this).addSwingEvent(this::swingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public CartElectricalLunaAbility(AbilityCore<CartElectricalLunaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.continuousComponent, this.swingTriggerComponent, this.projectileComponent});
        this.addCanUseCheck(CartElectroHelper.requireEleclaw(2));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 30.0f);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        if (this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.ELECTRO_CHARGING.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        boolean hasSulongActive = CartElectroHelper.hasSulongActive(entity);
        this.projectileComponent.getDamageBonusManager().removeBonus(CartElectroHelper.SULONG_DAMAGE_BONUS);
        this.cooldownComponent.getBonusManager().removeBonus(CartElectroHelper.SULONG_COOLDOWN_BONUS);
        if (hasSulongActive) {
            this.projectileComponent.getDamageBonusManager().addBonus(CartElectroHelper.SULONG_DAMAGE_BONUS, "Sulong Damage Bonus", BonusOperation.MUL, 2.0f);
            this.cooldownComponent.getBonusManager().addBonus(CartElectroHelper.SULONG_COOLDOWN_BONUS, "Sulong Cooldown Bonus", BonusOperation.MUL, 0.3f);
        }
        this.continuousComponent.startContinuity(entity);
        CartEleclawAbility eleclawAbility = (CartEleclawAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(CartEleclawAbility.INSTANCE);
        if (eleclawAbility != null) {
            eleclawAbility.reduceUsage(entity, 2);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 5.0f, 0.0f);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.LIGHTNING_TELEPORT.get(), SoundCategory.PLAYERS, 3.0f, 1.35f);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private void swingEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private CartElectricalLunaProjectile createProjectile(LivingEntity entity) {
        CartElectricalLunaProjectile proj = new CartElectricalLunaProjectile(entity.field_70170_p, entity, this);
        proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 0.0f);
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isMink() && props.getDoriki() >= 3600.0;
    }
}

