/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.electroextra;

import java.util.UUID;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.electroextra.CartSulongAbility;
import net.MrMagicalCart.cartaddon.api.abilities.CartPunchAbility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartEleclawAbility
extends CartPunchAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"eleclaw", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user coats their hands and weapons with lightning, enabling the use of other electric skills and giving the chance to stun foes.", null)});
    private static final int MAX_STACKS = 9;
    private static final int COOLDOWN = 200;
    public static final AbilityCore<CartEleclawAbility> INSTANCE = new AbilityCore.Builder("Eleclaw", AbilityCategory.RACIAL, CartEleclawAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f), ChangeStatsComponent.getTooltip(), StackComponent.getTooltip((int)9)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(CartEleclawAbility::canUnlock).build();
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("41635cd3-d290-4e65-933a-35541fa3c8d1"), INSTANCE, "Eleclaw Attack Speed Modifier", 0.35, AttributeModifier.Operation.ADDITION);
    private final StackComponent stackComponent = new StackComponent((IAbility)this, 9);
    private boolean waterCheck = false;

    public CartEleclawAbility(AbilityCore<CartEleclawAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.stackComponent});
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER);
        this.continuousComponent.addTickEvent(this::duringContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70090_H()) {
            this.waterCheck = true;
        }
        if (!entity.field_70170_p.field_72995_K && this.stackComponent.getStacks() <= 0) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.waterCheck = false;
        this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
    }

    @Override
    public float getPunchDamage() {
        if (this.waterCheck) {
            return 8.0f;
        }
        return 5.0f;
    }

    @Override
    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        if (entity.func_70681_au().nextInt(10) < 1) {
            target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 10, 0, false, false, true));
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GENERIC_LIGHTNING_USE.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_());
        }
        return true;
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    @Override
    public int getUseLimit() {
        return -1;
    }

    @Override
    public float getPunchCooldown() {
        return 200.0f;
    }

    @Override
    public boolean isParallel() {
        return true;
    }

    public void reduceUsage(LivingEntity entity, int number) {
        if (!entity.field_70170_p.field_72995_K) {
            boolean sulongEnabled;
            CartSulongAbility sulongAbility = (CartSulongAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(CartSulongAbility.INSTANCE);
            boolean bl = sulongEnabled = sulongAbility != null && sulongAbility.isContinuous();
            if (!sulongEnabled) {
                int newStacks = this.stackComponent.getStacks() - number;
                this.stackComponent.setStacks(entity, (IAbility)this, newStacks);
            }
        }
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        return props.isMink() && props.getDoriki() >= 500.0;
    }
}

