/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.dokuextra;

import java.util.ArrayList;
import java.util.List;
import net.MrMagicalCart.cartaddon.entities.projectiles.dokuextra.NewVenomRoadProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class NewVenomRoadAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"venom_road", (Pair[])new Pair[]{ImmutablePair.of((Object)"Fires a Hydra at the target location that stays there for a few seconds during which time the user can use them to move along their path.", null)});
    private static final ITextComponent NORMAL_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.venom_road", (String)"Venom Road"));
    private static final ITextComponent VENOM_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.venom_road_venom", (String)"Demon Road"));
    private static final ResourceLocation NORMAL_ICON = new ResourceLocation("mineminenomi", "textures/abilities/venom_road.png");
    private static final ResourceLocation VENOM_ICON = new ResourceLocation("mineminenomi", "textures/abilities/venom_road_venom.png");
    public static final int COOLDOWN = 120;
    public static final AbilityCore<NewVenomRoadAbility> INSTANCE = new AbilityCore.Builder("Venom Road", AbilityCategory.DEVIL_FRUITS, NewVenomRoadAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)120.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.POISON).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.NORMAL, true).addChangeModeEvent(this::onAltModeChange);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private boolean isMovingOwner;
    private int firstTick;
    private int ticks;
    private List<Pair<Vector3d, NewVenomRoadProjectile>> projectiles = new ArrayList<Pair<Vector3d, NewVenomRoadProjectile>>();
    private NewVenomRoadProjectile projectileUsed;

    public NewVenomRoadAbility(AbilityCore<NewVenomRoadAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.altModeComponent, this.animationComponent});
        this.addUseEvent(this::useEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.isMovingOwner) {
            boolean isNearStartPoint = false;
            for (Pair<Vector3d, NewVenomRoadProjectile> pair : this.projectiles) {
                if (pair.getValue() == null || !((NewVenomRoadProjectile)((Object)pair.getValue())).func_70089_S() || !entity.func_213303_ch().func_237488_a_((IPosition)pair.getKey(), 10.0)) continue;
                isNearStartPoint = true;
                this.projectileUsed = (NewVenomRoadProjectile)((Object)pair.getValue());
                break;
            }
            if (isNearStartPoint && AbilityHelper.canUseMomentumAbilities((LivingEntity)entity)) {
                entity.func_233576_c_(this.projectileUsed.getStartPos().func_72441_c(0.0, 1.0, 0.0));
                this.firstTick = this.ticks;
                this.isMovingOwner = true;
                this.animationComponent.start(entity, ModAnimations.SHOOT_SELF_FORWARD, 30);
            } else {
                this.projectiles.removeIf(pairx -> pairx.getValue() == null || !((NewVenomRoadProjectile)((Object)((Object)pairx.getValue()))).func_70089_S());
                if (this.projectiles.size() > 2) {
                    Pair firstPair = this.projectiles.stream().findFirst().orElse(null);
                    if (firstPair == null) {
                        return;
                    }
                    ((NewVenomRoadProjectile)((Object)firstPair.getValue())).func_70106_y();
                    this.projectiles.remove(firstPair);
                }
                this.isMovingOwner = false;
                NewVenomRoadProjectile projectile = (NewVenomRoadProjectile)this.projectileComponent.getNewProjectile(entity);
                entity.field_70170_p.func_217376_c((Entity)projectile);
                projectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 1.0f);
                ImmutablePair pair = ImmutablePair.of((Object)entity.func_213303_ch(), (Object)((Object)projectile));
                this.projectiles.add((Pair<Vector3d, NewVenomRoadProjectile>)pair);
                this.cooldownComponent.startCooldown(entity, 120.0f);
            }
        }
    }

    private NewVenomRoadProjectile createProjectile(LivingEntity entity) {
        boolean isDemonForm = ((MorphInfo)CartMorphs.VENOM_DEMON2.get()).isActive(entity);
        NewVenomRoadProjectile projectile = new NewVenomRoadProjectile(entity.field_70170_p, entity, this, isDemonForm);
        return projectile;
    }

    public void tickEvent(LivingEntity entity, IAbility ability) {
        ++this.ticks;
        if (!entity.field_70170_p.field_72995_K && this.isMovingOwner) {
            boolean pushedForTooLong;
            boolean hasArrived = entity.func_213303_ch().func_237488_a_((IPosition)this.projectileUsed.func_213303_ch(), 10.0);
            boolean bl = pushedForTooLong = this.ticks - this.firstTick > 40;
            if (hasArrived || pushedForTooLong) {
                this.isMovingOwner = false;
                this.cooldownComponent.startCooldown(entity, 80.0f);
                entity.field_70143_R = 0.0f;
                return;
            }
            if (AbilityHelper.canUseMomentumAbilities((LivingEntity)entity)) {
                Vector3d vec = this.projectileUsed.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_178788_d(this.projectileUsed.getStartPos()).func_72432_b().func_186678_a(3.0);
                AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)vec);
                entity.field_70143_R = 0.0f;
            }
        }
    }

    public void setNormalMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.NORMAL);
    }

    public void setVenomMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.VENOM);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.VENOM) {
            super.setDisplayName(VENOM_NAME);
            super.setDisplayIcon(VENOM_ICON);
        } else if (mode == Mode.NORMAL) {
            super.setDisplayName(NORMAL_NAME);
            super.setDisplayIcon(NORMAL_ICON);
        }
    }

    private static enum Mode {
        NORMAL,
        VENOM;

    }
}

