/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.dokuextra;

import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.dokuextra.NewChloroBallAbility;
import net.MrMagicalCart.cartaddon.abilities.dokuextra.NewDokuGumoAbility;
import net.MrMagicalCart.cartaddon.abilities.dokuextra.NewHydraAbility;
import net.MrMagicalCart.cartaddon.abilities.dokuextra.NewVenomRoadAbility;
import net.MrMagicalCart.cartaddon.api.helpers.HakiUsedChecker;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.events.FactionEvents;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NewVenomDemonAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"venom_demon", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user coats themselves in layers of strong corrosive venom, becoming a Venom Demon and leaving a highly poisonous trail. Also enhances all Posion abilities.", null)});
    private static final int COOLDOWN = 2000;
    private static final int HOLD_TIME = 1200;
    public static final AbilityCore<NewVenomDemonAbility> INSTANCE = new AbilityCore.Builder("Venom Demon", AbilityCategory.DEVIL_FRUITS, NewVenomDemonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)5.0f), ContinuousComponent.getTooltip((float)1200.0f), CooldownComponent.getTooltip((float)800.0f, (float)2000.0f), ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private static final AbilityAttributeModifier ATTACK_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Venom Demon Attack Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Venom Demon Reach Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Venom Demon Speed Modifier", 0.02, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Venom Demon Attack Speed Modifier", 0.15, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_ASSIST = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Venom Demon Step assist Modifier", 1.5, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_HEIGHT = new AbilityAttributeModifier(AttributeHelper.MORPH_JUMP_BOOST_UUID, INSTANCE, "Venom Demon Jump Height Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KNOCKBACK_RESISTANCE = new AbilityAttributeModifier(AttributeHelper.MORPH_KNOCKBACK_RESISTANCE_UUID, INSTANCE, "Venom Demon Knockback Resistance Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Venom Demon Armor Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS;
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS;
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(100, this::hitTriggerEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::damageTakenEvent, DamageTakenComponent.DamageState.HURT);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);

    public NewVenomDemonAbility(AbilityCore<NewVenomDemonAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.hitTriggerComponent, this.dealDamageComponent, this.damageTakenComponent});
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)ATTACK_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_ASSIST);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.FALL_RESISTANCE, (AttributeModifier)STEP_ASSIST);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_HEIGHT);
        this.statsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESISTANCE);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)TOUGHNESS);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)ARMOR_TOUGHNESS);
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addTickEvent(this::duringContinuityEvent);
        this.continuousComponent.addEndEvent(80, this::earlyEndContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
    }

    public void startContinuityEvent(LivingEntity entity, IAbility ability) {
        NewVenomRoadAbility venomRoad;
        NewDokuGumoAbility dokuGumo;
        NewChloroBallAbility chloroBall;
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        NewHydraAbility hydra = (NewHydraAbility)props.getEquippedAbility(NewHydraAbility.INSTANCE);
        if (hydra != null) {
            hydra.setVenomMode(entity);
        }
        if ((chloroBall = (NewChloroBallAbility)props.getEquippedAbility(NewChloroBallAbility.INSTANCE)) != null) {
            chloroBall.setVenomMode(entity);
        }
        if ((dokuGumo = (NewDokuGumoAbility)props.getEquippedAbility(NewDokuGumoAbility.INSTANCE)) != null) {
            dokuGumo.setVenomMode(entity);
        }
        if ((venomRoad = (NewVenomRoadAbility)props.getEquippedAbility(NewVenomRoadAbility.INSTANCE)) != null) {
            venomRoad.setVenomMode(entity);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.PHYSICAL_MOVING_GUARD.get(), 2, 3, false, false));
            if (!AbilityHelper.isWeakenedByKairosekiOrWater((LivingEntity)entity)) {
                BlockPos.Mutable mutpos = new BlockPos.Mutable();
                for (int x = -1; x < 1; ++x) {
                    for (int z = -1; z < 1; ++z) {
                        mutpos.func_189532_c(entity.func_226277_ct_() + (double)x, entity.func_226278_cu_(), entity.func_226281_cx_() + (double)z);
                        if (!entity.field_70170_p.func_180495_p(mutpos.func_177977_b()).func_185904_a().func_76220_a()) continue;
                        AbilityHelper.placeBlockIfAllowed((LivingEntity)entity, (BlockPos)mutpos, (BlockState)((Block)ModBlocks.DEMON_POISON.get()).func_176223_P(), (BlockProtectionRule)DefaultProtectionRules.AIR_FOLIAGE);
                    }
                }
            }
            if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.VENOM_DEMON.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            }
        }
    }

    private void earlyEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 800.0f + this.continuousComponent.getContinueTime());
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        NewVenomRoadAbility venomRoad;
        NewDokuGumoAbility dokuGumo;
        NewChloroBallAbility chloroBall;
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        NewHydraAbility hydra = (NewHydraAbility)props.getEquippedAbility(NewHydraAbility.INSTANCE);
        if (hydra != null) {
            hydra.setNormalMode(entity);
        }
        if ((chloroBall = (NewChloroBallAbility)props.getEquippedAbility(NewChloroBallAbility.INSTANCE)) != null) {
            chloroBall.setNormalMode(entity);
        }
        if ((dokuGumo = (NewDokuGumoAbility)props.getEquippedAbility(NewDokuGumoAbility.INSTANCE)) != null) {
            dokuGumo.setNormalMode(entity);
        }
        if ((venomRoad = (NewVenomRoadAbility)props.getEquippedAbility(NewVenomRoadAbility.INSTANCE)) != null) {
            venomRoad.setNormalMode(entity);
        }
    }

    private float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        Entity sourceEntity;
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (this.continuousComponent.isContinuous() && (sourceEntity = damageSource.func_76346_g()) != null && sourceEntity instanceof LivingEntity && FactionEvents.isDirectHit((DamageSource)damageSource)) {
            if (HakiUsedChecker.hasHasoInfusionOn((LivingEntity)sourceEntity)) {
                return damage;
            }
            if (HakiUsedChecker.hasInternalOn((LivingEntity)sourceEntity)) {
                return damage;
            }
            if (HakiUsedChecker.hasEmissionOn((LivingEntity)sourceEntity)) {
                return damage;
            }
            this.dealDamageComponent.hurtTarget(entity, (LivingEntity)sourceEntity, 5.0f, ModDamageSource.POISON);
            ((LivingEntity)sourceEntity).func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 100, 1));
        }
        return damage;
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.VENOM_DEMON2.get();
    }

    public float getContinuityHoldTime() {
        return 1200.0f;
    }

    public boolean hitTriggerEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b()) {
            source.setFistDamage().setSourceElement(SourceElement.POISON);
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 100, 1));
        }
        return true;
    }

    static {
        ARMOR_TOUGHNESS = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "Venom Demon Armor Toughness Modifier", 2.0, AttributeModifier.Operation.ADDITION);
        TOUGHNESS = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Venom Demon Toughness Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    }
}

